/*
 * Decompiled with CFR 0.152.
 */
package pd;

import java.awt.image.BufferedImage;
import java.util.Arrays;

public class CannyEdgeDetector {
    private static final float GAUSSIAN_CUT_OFF = 0.005f;
    private static final float MAGNITUDE_SCALE = 100.0f;
    private static final float MAGNITUDE_LIMIT = 1000.0f;
    private static final int MAGNITUDE_MAX = 100000;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] magnitude;
    private BufferedImage sourceImage;
    private BufferedImage edgesImage;
    private float gaussianKernelRadius = 2.0f;
    private float lowThreshold = 2.5f;
    private float highThreshold = 7.5f;
    private int gaussianKernelWidth = 16;
    private boolean contrastNormalized = false;
    private float[] xConv;
    private float[] yConv;
    private float[] xGradient;
    private float[] yGradient;

    public BufferedImage getSourceImage() {
        return this.sourceImage;
    }

    public void setSourceImage(BufferedImage bufferedImage) {
        this.sourceImage = bufferedImage;
    }

    public BufferedImage getEdgesImage() {
        return this.edgesImage;
    }

    public void setEdgesImage(BufferedImage bufferedImage) {
        this.edgesImage = bufferedImage;
    }

    public float getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.lowThreshold = f;
    }

    public float getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.highThreshold = f;
    }

    public int getGaussianKernelWidth() {
        return this.gaussianKernelWidth;
    }

    public void setGaussianKernelWidth(int n) {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        this.gaussianKernelWidth = n;
    }

    public float getGaussianKernelRadius() {
        return this.gaussianKernelRadius;
    }

    public void setGaussianKernelRadius(float f) {
        if (f < 0.1f) {
            throw new IllegalArgumentException();
        }
        this.gaussianKernelRadius = f;
    }

    public boolean isContrastNormalized() {
        return this.contrastNormalized;
    }

    public void setContrastNormalized(boolean bl) {
        this.contrastNormalized = bl;
    }

    public void process() {
        this.width = this.sourceImage.getWidth();
        this.height = this.sourceImage.getHeight();
        this.picsize = this.width * this.height;
        this.initArrays();
        this.readLuminance();
        if (this.contrastNormalized) {
            this.normalizeContrast();
        }
        this.computeGradients(this.gaussianKernelRadius, this.gaussianKernelWidth);
        int n = Math.round(this.lowThreshold * 100.0f);
        int n2 = Math.round(this.highThreshold * 100.0f);
        this.performHysteresis(n, n2);
        this.thresholdEdges();
        this.writeEdges(this.data);
    }

    private void initArrays() {
        if (this.data == null || this.picsize != this.data.length) {
            this.data = new int[this.picsize];
            this.magnitude = new int[this.picsize];
            this.xConv = new float[this.picsize];
            this.yConv = new float[this.picsize];
            this.xGradient = new float[this.picsize];
            this.yGradient = new float[this.picsize];
        }
    }

    private void computeGradients(float f, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        float f2;
        int n6;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        for (n6 = 0; !(n6 >= n || (f2 = this.gaussian(n6, f)) <= 0.005f && n6 >= 2); ++n6) {
            float f3 = this.gaussian((float)n6 - 0.5f, f);
            float f4 = this.gaussian((float)n6 + 0.5f, f);
            fArray[n6] = (f2 + f3 + f4) / 3.0f / ((float)Math.PI * 2 * f * f);
            fArray2[n6] = f4 - f3;
        }
        int n7 = n6 - 1;
        int n8 = this.width - (n6 - 1);
        int n9 = this.width * (n6 - 1);
        int n10 = this.width * (this.height - (n6 - 1));
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f5;
                int n11 = n5 + n4;
                float f6 = f5 = (float)this.data[n11] * fArray[0];
                n3 = this.width;
                for (n2 = 1; n2 < n6; ++n2) {
                    f6 += fArray[n2] * (float)(this.data[n11 - n3] + this.data[n11 + n3]);
                    f5 += fArray[n2] * (float)(this.data[n11 - n2] + this.data[n11 + n2]);
                    n3 += this.width;
                }
                this.yConv[n11] = f6;
                this.xConv[n11] = f5;
            }
        }
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f7 = 0.0f;
                int n12 = n5 + n4;
                for (int i = 1; i < n6; ++i) {
                    f7 += fArray2[i] * (this.yConv[n12 - i] - this.yConv[n12 + i]);
                }
                this.xGradient[n12] = f7;
            }
        }
        for (n5 = n6; n5 < this.width - n6; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                float f8 = 0.0f;
                int n13 = n5 + n4;
                int n14 = this.width;
                for (n2 = 1; n2 < n6; ++n2) {
                    f8 += fArray2[n2] * (this.xConv[n13 - n14] - this.xConv[n13 + n14]);
                    n14 += this.width;
                }
                this.yGradient[n13] = f8;
            }
        }
        n7 = n6;
        n8 = this.width - n6;
        n9 = this.width * n6;
        n10 = this.width * (this.height - n6);
        for (n5 = n7; n5 < n8; ++n5) {
            for (n4 = n9; n4 < n10; n4 += this.width) {
                block16: {
                    float f9;
                    block17: {
                        float f10;
                        float f11;
                        float f12;
                        float f13;
                        float f14;
                        float f15;
                        float f16;
                        float f17;
                        block18: {
                            float f18;
                            float f19;
                            float f20;
                            block14: {
                                float f21;
                                float f22;
                                float f23;
                                block15: {
                                    float f24;
                                    int n15 = n5 + n4;
                                    int n16 = n15 - this.width;
                                    int n17 = n15 + this.width;
                                    n2 = n15 - 1;
                                    n3 = n15 + 1;
                                    int n18 = n16 - 1;
                                    int n19 = n16 + 1;
                                    int n20 = n17 - 1;
                                    int n21 = n17 + 1;
                                    f17 = this.xGradient[n15];
                                    f16 = this.yGradient[n15];
                                    f9 = this.hypot(f17, f16);
                                    f15 = this.hypot(this.xGradient[n16], this.yGradient[n16]);
                                    f14 = this.hypot(this.xGradient[n17], this.yGradient[n17]);
                                    f20 = this.hypot(this.xGradient[n2], this.yGradient[n2]);
                                    f19 = this.hypot(this.xGradient[n3], this.yGradient[n3]);
                                    f23 = this.hypot(this.xGradient[n19], this.yGradient[n19]);
                                    f13 = this.hypot(this.xGradient[n21], this.yGradient[n21]);
                                    f22 = this.hypot(this.xGradient[n20], this.yGradient[n20]);
                                    f12 = this.hypot(this.xGradient[n18], this.yGradient[n18]);
                                    if (!(f17 * f16 <= 0.0f)) break block14;
                                    if (!(Math.abs(f17) >= Math.abs(f16))) break block15;
                                    f11 = Math.abs(f17 * f9);
                                    if (!(f24 >= Math.abs(f16 * f23 - (f17 + f16) * f19)) || !(f11 > Math.abs(f16 * f22 - (f17 + f16) * f20))) break block16;
                                    break block17;
                                }
                                f11 = Math.abs(f16 * f9);
                                if (!(f21 >= Math.abs(f17 * f23 - (f16 + f17) * f15)) || !(f11 > Math.abs(f17 * f22 - (f16 + f17) * f14))) break block16;
                                break block17;
                            }
                            if (!(Math.abs(f17) >= Math.abs(f16))) break block18;
                            f11 = Math.abs(f17 * f9);
                            if (!(f18 >= Math.abs(f16 * f13 + (f17 - f16) * f19)) || !(f11 > Math.abs(f16 * f12 + (f17 - f16) * f20))) break block16;
                            break block17;
                        }
                        f11 = Math.abs(f16 * f9);
                        if (!(f10 >= Math.abs(f17 * f13 + (f16 - f17) * f14)) || !(f11 > Math.abs(f17 * f12 + (f16 - f17) * f15))) break block16;
                    }
                    this.magnitude[n15] = f9 >= 1000.0f ? 100000 : (int)(100.0f * f9);
                    continue;
                }
                this.magnitude[n15] = 0;
            }
        }
    }

    private float hypot(float f, float f2) {
        return (float)Math.hypot(f, f2);
    }

    private float gaussian(float f, float f2) {
        return (float)Math.exp(-(f * f) / (2.0f * f2 * f2));
    }

    private void performHysteresis(int n, int n2) {
        Arrays.fill(this.data, 0);
        int n3 = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.data[n3] == 0 && this.magnitude[n3] >= n2) {
                    this.follow(i, j, n3, n);
                }
                ++n3;
            }
        }
    }

    private void follow(int n, int n2, int n3, int n4) {
        int n5 = n == 0 ? n : n - 1;
        int n6 = n == this.width - 1 ? n : n + 1;
        int n7 = n2 == 0 ? n2 : n2 - 1;
        int n8 = n2 == this.height - 1 ? n2 : n2 + 1;
        this.data[n3] = this.magnitude[n3];
        for (int i = n5; i <= n6; ++i) {
            for (int j = n7; j <= n8; ++j) {
                int n9 = i + j * this.width;
                if (j == n2 && i == n || this.data[n9] != 0 || this.magnitude[n9] < n4) continue;
                this.follow(i, j, n9, n4);
                return;
            }
        }
    }

    private void thresholdEdges() {
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > 0 ? -1 : -16777216;
        }
    }

    private int luminance(float f, float f2, float f3) {
        return Math.round(0.299f * f + 0.587f * f2 + 0.114f * f3);
    }

    private void readLuminance() {
        int n = this.sourceImage.getType();
        if (n == 1 || n == 2) {
            int[] nArray = (int[])this.sourceImage.getData().getDataElements(0, 0, this.width, this.height, null);
            for (int i = 0; i < this.picsize; ++i) {
                int n2 = nArray[i];
                int n3 = (n2 & 0xFF0000) >> 16;
                int n4 = (n2 & 0xFF00) >> 8;
                int n5 = n2 & 0xFF;
                this.data[i] = this.luminance(n3, n4, n5);
            }
        } else if (n == 3) {
            int[] nArray = (int[])this.sourceImage.getData().getDataElements(0, 0, this.width, this.height, null);
            for (int i = 0; i < this.picsize; ++i) {
                int n6 = nArray[i];
                int n7 = n6 >>> 24 & 0xFF;
                int n8 = (n6 & 0xFF0000) >> 16;
                int n9 = (n6 & 0xFF00) >> 8;
                int n10 = n6 & 0xFF;
                int n11 = this.luminance(n8, n9, n10);
                if (n7 != 255) {
                    if (n7 == 0) {
                        n11 = 0;
                    } else {
                        float f = (float)n7 / 255.0f;
                        if ((n11 = (int)((float)n11 / f)) > 255) {
                            n11 = 255;
                        }
                    }
                }
                this.data[i] = n11;
            }
        } else if (n == 10) {
            byte[] byArray = (byte[])this.sourceImage.getData().getDataElements(0, 0, this.width, this.height, null);
            for (int i = 0; i < this.picsize; ++i) {
                this.data[i] = byArray[i] & 0xFF;
            }
        } else if (n == 11) {
            short[] sArray = (short[])this.sourceImage.getData().getDataElements(0, 0, this.width, this.height, null);
            for (int i = 0; i < this.picsize; ++i) {
                this.data[i] = (sArray[i] & 0xFFFF) / 256;
            }
        } else if (n == 5) {
            byte[] byArray = (byte[])this.sourceImage.getData().getDataElements(0, 0, this.width, this.height, null);
            int n12 = 0;
            for (int i = 0; i < this.picsize; ++i) {
                int n13 = byArray[n12++] & 0xFF;
                int n14 = byArray[n12++] & 0xFF;
                int n15 = byArray[n12++] & 0xFF;
                this.data[i] = this.luminance(n15, n14, n13);
            }
        } else {
            throw new IllegalArgumentException("Unsupported image type: " + n);
        }
    }

    private void normalizeContrast() {
        int n;
        int[] nArray = new int[256];
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = this.data[i];
            nArray[n2] = nArray[n2] + 1;
        }
        int[] nArray2 = new int[256];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n5 = (n3 += nArray[n]) * 255 / this.picsize;
            for (int i = n4 + 1; i <= n5; ++i) {
                nArray2[i] = n;
            }
            n4 = n5;
        }
        for (n = 0; n < this.data.length; ++n) {
            this.data[n] = nArray2[this.data[n]];
        }
    }

    private void writeEdges(int[] nArray) {
        if (this.edgesImage == null) {
            this.edgesImage = new BufferedImage(this.width, this.height, 2);
        }
        this.edgesImage.getWritableTile(0, 0).setDataElements(0, 0, this.width, this.height, nArray);
    }
}

