/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.logging.Level;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import pixelitor.Build;
import pixelitor.PixelitorWindow;
import pixelitor.history.History;
import pixelitor.utils.test.DebugEventQueue;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public static ExceptionHandler INSTANCE = new ExceptionHandler();
    private static boolean mainWindowInitialized = false;

    private ExceptionHandler() {
    }

    public void register() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof ClassCastException) {
            throwable.printStackTrace();
            return;
        }
        ExceptionHandler.showExceptionDialog(throwable);
    }

    private static Frame getParentForDialogs() {
        if (mainWindowInitialized) {
            return PixelitorWindow.getInstance();
        }
        return null;
    }

    public static void showExceptionDialog(Throwable throwable) {
        throwable.printStackTrace();
        if (Build.CURRENT.isRobotTest()) {
            DebugEventQueue.dump();
            History.showHistory();
            Toolkit.getDefaultToolkit().beep();
            ExceptionHandler.playWarningSound();
        }
        Frame frame = ExceptionHandler.getParentForDialogs();
        String string = "An exception occurred: " + throwable.getMessage();
        ErrorInfo errorInfo = new ErrorInfo("Program error", string, null, null, throwable, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)frame, errorInfo);
    }

    public static void playWarningSound() {
        try {
            int n = 127;
            int n2 = 65;
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            MidiChannel midiChannel = synthesizer.getChannels()[9];
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                midiChannel.noteOn(n2 + i, n);
                Thread.sleep(100L);
                midiChannel.noteOff(n2 + i);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void showOutOfMemoryDialog() {
        String string = "Out of the Java heap space. Try increasing the maximal memory available to Pixelitor with -Xmx";
        String string2 = "Out of memory error. Try increasing the memory available to Pixelitor with -Xmx";
        JOptionPane.showMessageDialog(ExceptionHandler.getParentForDialogs(), string, string2, 0);
    }

    public static void showInfoDialog(String string, String string2) {
        JOptionPane.showMessageDialog(ExceptionHandler.getParentForDialogs(), string2, string, 1);
    }

    public static void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(ExceptionHandler.getParentForDialogs(), string2, string, 0);
    }

    public static void setMainWindowInitialized(boolean bl) {
        mainWindowInitialized = bl;
    }

    public static boolean isMainWindowInitialized() {
        return mainWindowInitialized;
    }

    public static void showNotImageLayerDialog() {
        if (!Build.CURRENT.isRobotTest()) {
            ExceptionHandler.showErrorDialog("Error", "The active layer is not an image layer");
        }
    }
}

