/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.EventQueue;
import java.io.File;
import javax.swing.UIManager;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.TipsOfTheDay;
import pixelitor.io.OpenSaveManager;
import pixelitor.layers.Layers;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.utils.AppPreferences;

public class Pixelitor {
    private Pixelitor() {
    }

    public static void main(final String[] stringArray) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Pixelitor");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ExceptionHandler.INSTANCE.register();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Pixelitor.createAndShowGUI(stringArray);
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        });
    }

    private static void createAndShowGUI(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(AppPreferences.getDefaultLookAndFeelClass());
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
        Layers.init();
        PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
        ExceptionHandler.setMainWindowInitialized(true);
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                File file = new File(string);
                if (file.exists()) {
                    OpenSaveManager.openFile(file);
                    continue;
                }
                ExceptionHandler.showErrorDialog("File not found", "The file \"" + file.getAbsolutePath() + "\" does not exist");
            }
        } else {
            FgBgColorSelector.INSTANCE.requestFocus();
        }
        TipsOfTheDay.showTips(pixelitorWindow, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OpenSaveManager.initOpenFileChooser();
                OpenSaveManager.initSaveFileChooser();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(5);
        thread.start();
        Pixelitor.afterStartTestActions(pixelitorWindow);
    }

    private static void afterStartTestActions(PixelitorWindow pixelitorWindow) {
    }
}

