/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import com.jhlabs.image.ImageMath;
import java.awt.image.BufferedImage;
import java.util.Random;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class AddNoise
extends FilterWithParametrizedGUI {
    private RangeParam opacity = new RangeParam("Opacity (%)", 0, 100, 100);
    private RangeParam coverage = new RangeParam("Coverage (%)", 0, 100, 50);

    public AddNoise() {
        super("Add Noise");
        this.paramSet = new ParamSet(this.opacity, this.coverage);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        float f = this.opacity.getValueAsPercentage();
        float f2 = this.coverage.getValueAsPercentage();
        Random random = new Random();
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            float f3 = random.nextFloat();
            if (f3 > f2) {
                nArray2[i] = n;
                continue;
            }
            int n2 = 0xFF000000 & n;
            if (n2 == 0) {
                nArray2[i] = 0;
                continue;
            }
            int n3 = random.nextInt();
            nArray2[i] = ImageMath.mixColors(f, n, n3 |= n2);
        }
        return bufferedImage2;
    }
}

