/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BlendingModeParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.layers.BlendingMode;
import pixelitor.utils.ImageUtils;

public class Brick
extends FilterWithParametrizedGUI {
    private RangeParam sizeParam = new RangeParam("Size", 5, 100, 10);
    private BlendingModeParam blendingModeParam = new BlendingModeParam(BlendingMode.values());
    private AngleParam lightAngleParam = new AngleParam("Light Direction (Azimuth) - Degrees", 0.7853981634);

    public Brick() {
        super("Brick");
        this.paramSet = new ParamSet(this.sizeParam, this.lightAngleParam, this.blendingModeParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.sizeParam.getValue();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage3 = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setColor(Color.GRAY);
        ImageUtils.drawBrickGrid(graphics2D, n, n2, n3);
        graphics2D.dispose();
        float f = (float)this.lightAngleParam.getValueInIntuitiveRadians();
        bufferedImage2 = ImageUtils.bumpMap(bufferedImage, bufferedImage3, this.blendingModeParam.getSelectedBlendingMode().getComposite(1.0f), f, 0.5235988f, 1.0f);
        return bufferedImage2;
    }
}

