/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class Brightness
extends FilterWithParametrizedGUI {
    private RangeParam power = new RangeParam("Power (%)", 50, 150, 100);
    private RangeParam multiply = new RangeParam("Multiply (%)", 1, 200, 100);
    private RangeParam add = new RangeParam("Add", -255, 255, 0);

    public Brightness() {
        super("Brightness");
        this.paramSet = new ParamSet(this.power, this.multiply, this.add);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        int n3 = this.add.getValue();
        if (n3 == 0 && this.multiply.getValue() == 100 && this.power.getValue() == 100) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        float f = this.multiply.getValueAsPercentage();
        float f2 = this.power.getValueAsPercentage();
        int[] nArray3 = new int[256];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            float f3 = n2;
            f3 = (float)Math.pow(f3, f2);
            n = (int)(f3 * f) + n3;
            nArray3[n2] = ImageUtils.limitTo8Bits(n);
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            int n4 = nArray[n2];
            n = n4 & 0xFF000000;
            int n5 = n4 >>> 16 & 0xFF;
            int n6 = n4 >>> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            if (n == 0) {
                nArray2[n2] = 0;
                continue;
            }
            n5 = nArray3[n5];
            n6 = nArray3[n6];
            n7 = nArray3[n7];
            nArray2[n2] = n | n5 << 16 | n6 << 8 | n7;
        }
        return bufferedImage2;
    }
}

