/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pd.CannyEdgeDetector;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class Canny
extends FilterWithParametrizedGUI {
    private RangeParam lowThreshold = new RangeParam("Low Threshold", 1, 1000, 250);
    private RangeParam highThreshold = new RangeParam("High Threshold", 1, 1000, 750);
    private RangeParam gaussianKernelWidth = new RangeParam("Gaussian Kernel Width", 2, 50, 16);
    private RangeParam gaussianKernelRadius = new RangeParam("Gaussian Kernel Radius", 1, 10, 2);
    private BooleanParam contrastNormalized = new BooleanParam("Contrast Normalized", false);

    public Canny() {
        super("Canny Edge Detector");
        this.paramSet = new ParamSet(this.lowThreshold, this.highThreshold, this.gaussianKernelWidth, this.gaussianKernelRadius, this.contrastNormalized);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        CannyEdgeDetector cannyEdgeDetector = new CannyEdgeDetector();
        cannyEdgeDetector.setLowThreshold(this.lowThreshold.getValueAsPercentage());
        cannyEdgeDetector.setHighThreshold(this.highThreshold.getValueAsPercentage());
        cannyEdgeDetector.setContrastNormalized(this.contrastNormalized.getValue());
        cannyEdgeDetector.setGaussianKernelRadius(this.gaussianKernelRadius.getValue());
        cannyEdgeDetector.setGaussianKernelWidth(this.gaussianKernelWidth.getValue());
        cannyEdgeDetector.setSourceImage(bufferedImage);
        cannyEdgeDetector.process();
        bufferedImage2 = cannyEdgeDetector.getEdgesImage();
        return bufferedImage2;
    }
}

