/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.utils.ImageUtils;

public class ChannelInvert
extends FilterWithParametrizedGUI {
    private static final int NOTHING = 0;
    private static final int RED_ONLY = 1;
    private static final int GREEN_ONLY = 2;
    private static final int BLUE_ONLY = 3;
    private static final int RED_GREEN = 4;
    private static final int RED_BLUE = 5;
    private static final int GREEN_BLUE = 6;
    private static final int RED_GREEN_BLUE = 7;
    private static final int HUE_ONLY = 8;
    private static final int SATURATION_ONLY = 9;
    private static final int BRI_ONLY = 10;
    private static final int HUE_SAT = 11;
    private static final int HUE_BRI = 12;
    private static final int SAT_BRI = 13;
    private static final int HUE_SAT_BRI = 14;
    private IntChoiceParam.Value[] invertChoices = new IntChoiceParam.Value[]{new IntChoiceParam.Value("Nothing", 0), new IntChoiceParam.Value("Hue", 8), new IntChoiceParam.Value("Saturation", 9), new IntChoiceParam.Value("Brightness", 10), new IntChoiceParam.Value("Hue and Saturation", 11), new IntChoiceParam.Value("Hue and Brightness", 12), new IntChoiceParam.Value("Saturation and Brightness", 13), new IntChoiceParam.Value("Hue, Saturation and Brightness", 14), new IntChoiceParam.Value("Red", 1), new IntChoiceParam.Value("Green", 2), new IntChoiceParam.Value("Blue", 3), new IntChoiceParam.Value("Red and Green", 4), new IntChoiceParam.Value("Red and Blue", 5), new IntChoiceParam.Value("Green and Blue", 6), new IntChoiceParam.Value("Red, Green and Blue", 7)};
    private IntChoiceParam invertTypeSelector = new IntChoiceParam("Invert Channel", this.invertChoices);

    public ChannelInvert() {
        super("Channel Invert");
        this.paramSet = new ParamSet((GUIParam)this.invertTypeSelector);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.invertTypeSelector.getValue();
        if (n == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (n >= 8) {
            return ChannelInvert.invertHSB(n, bufferedImage, bufferedImage2);
        }
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        block9: for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray[i];
            int n3 = n2 & 0xFF000000;
            if (n3 == 0) {
                nArray2[i] = n2;
                continue;
            }
            switch (n) {
                case 1: {
                    nArray2[i] = n2 ^ 0xFF0000;
                    continue block9;
                }
                case 2: {
                    nArray2[i] = n2 ^ 0xFF00;
                    continue block9;
                }
                case 3: {
                    nArray2[i] = n2 ^ 0xFF;
                    continue block9;
                }
                case 4: {
                    nArray2[i] = n2 ^ 0xFFFF00;
                    continue block9;
                }
                case 5: {
                    nArray2[i] = n2 ^ 0xFF00FF;
                    continue block9;
                }
                case 6: {
                    nArray2[i] = n2 ^ 0xFFFF;
                    continue block9;
                }
                case 7: {
                    nArray2[i] = n2 ^ 0xFFFFFF;
                }
            }
        }
        return bufferedImage2;
    }

    private static BufferedImage invertHSB(int n, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray[i];
            int n3 = n2 & 0xFF000000;
            if (n3 == 0) {
                nArray2[i] = n2;
                continue;
            }
            int n4 = n2 >>> 16 & 0xFF;
            int n5 = n2 >>> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            fArray = Color.RGBtoHSB(n4, n5, n6, fArray);
            int n7 = 0;
            switch (n) {
                case 8: {
                    n7 = Color.HSBtoRGB(0.5f + fArray[0], fArray[1], fArray[2]);
                    break;
                }
                case 10: {
                    n7 = Color.HSBtoRGB(fArray[0], fArray[1], 1.0f - fArray[2]);
                    break;
                }
                case 9: {
                    n7 = Color.HSBtoRGB(fArray[0], 1.0f - fArray[1], fArray[2]);
                    break;
                }
                case 12: {
                    n7 = Color.HSBtoRGB(0.5f + fArray[0], fArray[1], 1.0f - fArray[2]);
                    break;
                }
                case 11: {
                    n7 = Color.HSBtoRGB(0.5f + fArray[0], 1.0f - fArray[1], fArray[2]);
                    break;
                }
                case 13: {
                    n7 = Color.HSBtoRGB(fArray[0], 1.0f - fArray[1], 1.0f - fArray[2]);
                    break;
                }
                case 14: {
                    n7 = Color.HSBtoRGB(0.5f + fArray[0], 1.0f - fArray[1], 1.0f - fArray[2]);
                }
            }
            nArray2[i] = n3 | (n7 &= 0xFFFFFF);
        }
        return bufferedImage2;
    }
}

