/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class Clouds
extends FilterWithParametrizedGUI {
    private static int[] p;
    private RangeParam scaleParam = new RangeParam("Zoom (%)", 3, 300, 100);
    private RangeParam roughnessParam = new RangeParam("Roughness (%)", 1, 100, 50);
    private ColorParam color1Param = new ColorParam("Color 1", Color.BLACK, true, false);
    private ColorParam color2Param = new ColorParam("Color 2", Color.WHITE, true, false);
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clouds.reseed();
        }
    });

    public Clouds() {
        super("Clouds");
        this.paramSet = new ParamSet(this.scaleParam, this.roughnessParam, this.color1Param, this.color2Param, this.reseedAction);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.scaleParam.getValue();
        float f = this.roughnessParam.getValueAsPercentage();
        Color color = this.color1Param.getColor();
        Color color2 = this.color2Param.getColor();
        Clouds.renderClouds(bufferedImage2, n, f, color, color2);
        return bufferedImage2;
    }

    public static void renderClouds(BufferedImage bufferedImage, int n, float f, Color color, Color color2) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = new int[]{color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue()};
        int[] nArray3 = new int[]{color2.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue()};
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = n;
                float f2 = 0.0f;
                float f3 = 1.0f;
                for (int k = 0; k < 8 && f3 > 0.03f && n4 > 0; n4 /= 2, f3 *= f, ++k) {
                    float f4 = (float)i / (float)n4;
                    float f5 = (float)j / (float)n4;
                    float f6 = Clouds.perlinNoise2D(f4, f5);
                    f2 += f3 * f6;
                }
                if ((f2 = (1.0f + f2) / 2.0f) < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                nArray[i + j * n2] = ImageUtils.lerpAndPremultiplyColorWithAlpha(f2, nArray2, nArray3);
            }
        }
    }

    private static float perlinNoise2D(float f, float f2) {
        int n = (int)f & 0xFF;
        int n2 = (int)f2 & 0xFF;
        f -= (float)((int)f);
        f2 -= (float)((int)f2);
        float f3 = Clouds.fade(f);
        float f4 = Clouds.fade(f2);
        int n3 = p[n] + n2;
        int n4 = p[n3];
        int n5 = p[n3 + 1];
        int n6 = p[n + 1] + n2;
        int n7 = p[n6];
        int n8 = p[n6 + 1];
        float f5 = Clouds.grad2D(p[n4], f, f2);
        float f6 = Clouds.grad2D(p[n7], f - 1.0f, f2);
        float f7 = Clouds.grad2D(p[n5], f, f2 - 1.0f);
        float f8 = Clouds.grad2D(p[n8], f - 1.0f, f2 - 1.0f);
        float f9 = Clouds.lerp(f3, f5, f6);
        float f10 = Clouds.lerp(f3, f7, f8);
        float f11 = Clouds.lerp(f4, f9, f10);
        return f11;
    }

    private static float fade(float f) {
        return f * f * f * (f * (f * 6.0f - 15.0f) + 10.0f);
    }

    private static float grad2D(int n, float f, float f2) {
        int n2 = n & 0xF;
        float f3 = n2 < 8 ? f : f2;
        float f4 = n2 < 4 ? f2 : f;
        return ((n2 & 1) == 0 ? f3 : -f3) + ((n2 & 2) == 0 ? f4 : -f4);
    }

    private static float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    public static void reseed() {
        p = new int[512];
        for (int i = 0; i < 256; ++i) {
            Clouds.p[i] = i;
        }
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            int n = random.nextInt(256);
            int n2 = p[i];
            Clouds.p[i] = p[n];
            Clouds.p[n] = n2;
            Clouds.p[i + 256] = p[i];
        }
    }

    static {
        Clouds.reseed();
    }
}

