/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import java.awt.image.LookupTable;
import java.awt.image.ShortLookupTable;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.RGBPixelOp;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.lookup.FastLookupOp;
import pixelitor.filters.lookup.LookupFactory;

public class ExtractChannel
extends FilterWithParametrizedGUI {
    private static final int RED_CHANNEL = 1;
    private static final int REMOVE_RED_CHANNEL = 2;
    private static final int GREEN_CHANNEL = 3;
    private static final int REMOVE_GREEN_CHANNEL = 4;
    private static final int BLUE_CHANNEL = 5;
    private static final int REMOVE_BLUE_CHANNEL = 6;
    private IntChoiceParam channelParam = new IntChoiceParam("Channel", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Red", 1), new IntChoiceParam.Value("Remove Red", 2), new IntChoiceParam.Value("Green", 3), new IntChoiceParam.Value("Remove Green", 4), new IntChoiceParam.Value("Blue", 5), new IntChoiceParam.Value("Remove Blue", 6)});
    private BooleanParam bwParam = new BooleanParam("Black and White", false);

    public ExtractChannel() {
        super("Extract Channel");
        this.paramSet = new ParamSet(this.channelParam, this.bwParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.channelParam.getValue();
        if (this.bwParam.getValue()) {
            switch (n) {
                case 1: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            n3 = n2;
                            n4 = n2;
                            return n << 24 | n2 << 16 | n3 << 8 | n4;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
                case 2: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            int n5 = (n3 + n4) / 2;
                            return n << 24 | n5 << 16 | n5 << 8 | n5;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
                case 3: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            n2 = n3;
                            n4 = n3;
                            return n << 24 | n2 << 16 | n3 << 8 | n4;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
                case 4: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            int n5 = (n2 + n4) / 2;
                            return n << 24 | n5 << 16 | n5 << 8 | n5;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
                case 5: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            n2 = n4;
                            n3 = n4;
                            return n << 24 | n2 << 16 | n3 << 8 | n4;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
                case 6: {
                    RGBPixelOp rGBPixelOp = new RGBPixelOp(){

                        @Override
                        public int changeRGB(int n, int n2, int n3, int n4) {
                            int n5 = (n2 + n3) / 2;
                            return n << 24 | n5 << 16 | n5 << 8 | n5;
                        }
                    };
                    return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
                }
            }
            throw new IllegalStateException("should not het here");
        }
        this.colorExtractChannel(bufferedImage, bufferedImage2, n);
        return bufferedImage2;
    }

    private void colorExtractChannel(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        LookupTable lookupTable;
        switch (n) {
            case 1: {
                lookupTable = LookupFactory.createLookupForOnlyRed();
                break;
            }
            case 2: {
                lookupTable = LookupFactory.createLookupForRemoveRed();
                break;
            }
            case 3: {
                lookupTable = LookupFactory.createLookupForOnlyGreen();
                break;
            }
            case 4: {
                lookupTable = LookupFactory.createLookupForRemoveGreen();
                break;
            }
            case 5: {
                lookupTable = LookupFactory.createLookupForOnlyBlue();
                break;
            }
            case 6: {
                lookupTable = LookupFactory.createLookupForRemoveBlue();
                break;
            }
            default: {
                throw new IllegalStateException("should not het here");
            }
        }
        FastLookupOp fastLookupOp = new FastLookupOp((ShortLookupTable)lookupTable);
        fastLookupOp.filter(bufferedImage, bufferedImage2);
    }
}

