/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.impl.TileFilter;

public class GlassTile
extends FilterWithParametrizedGUI {
    private CoupledRangeParam size = new CoupledRangeParam("Tile Size", 5, 500, 50);
    private RangeParam curvature = new RangeParam("Curvature", 0, 20, 10);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private TileFilter filter;

    public GlassTile() {
        super("Glass Tile");
        this.paramSet = new ParamSet(this.size, this.curvature, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new TileFilter();
        }
        this.filter.setSizeX(this.size.getFirstValue());
        this.filter.setSizeY(this.size.getSecondValue());
        this.filter.setCurvature(this.curvature.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

