/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class HueSat
extends FilterWithParametrizedGUI {
    private static final int MIN_HUE = -180;
    private static final int MAX_HUE = 180;
    private static final int DEFAULT_HUE = 0;
    private static final int MIN_SAT = -100;
    private static final int MAX_SAT = 100;
    private static final int DEFAULT_SAT = 0;
    private static final int MIN_BRI = -100;
    private static final int MAX_BRI = 100;
    private static final int DEFAULT_BRI = 0;
    private RangeParam hueParam = new RangeParam("Hue", -180, 180, 0);
    private RangeParam saturationParam = new RangeParam("Saturation", -100, 100, 0);
    private RangeParam brightnessParam = new RangeParam("Brightness", -100, 100, 0);

    public HueSat() {
        super("Hue/Saturation");
        this.paramSet = new ParamSet(this.hueParam, this.saturationParam, this.brightnessParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray;
        int n = this.hueParam.getValue();
        int n2 = this.saturationParam.getValue();
        int n3 = this.brightnessParam.getValue();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        float f = (float)n2 / 100.0f;
        float f2 = (float)n3 / 100.0f;
        float f3 = (float)n / 360.0f;
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage);
        int n4 = nArray2.length;
        if (n4 != (nArray = ImageUtils.getPixelsAsArray(bufferedImage2)).length) {
            throw new IllegalArgumentException("src and dest are not the same size");
        }
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray2[i];
            int n6 = n5 & 0xFF000000;
            int n7 = n5 >>> 16 & 0xFF;
            int n8 = n5 >>> 8 & 0xFF;
            int n9 = n5 & 0xFF;
            fArray = Color.RGBtoHSB(n7, n8, n9, fArray);
            float f4 = fArray[0] + f3;
            float f5 = fArray[1] + f;
            float f6 = fArray[2] + f2;
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            int n10 = Color.HSBtoRGB(f4, f5, f6);
            nArray[i] = n6 | (n10 &= 0xFFFFFF);
        }
        return bufferedImage2;
    }
}

