/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.impl.MirrorFilter;

public class Mirror
extends FilterWithParametrizedGUI {
    private AngleParam angle = new AngleParam("Angle", 0.0);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private IntChoiceParam typeParam = new IntChoiceParam("Type", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Left Over Right", 0), new IntChoiceParam.Value("Right Over Left", 1), new IntChoiceParam.Value("Bottom Over Top", 2), new IntChoiceParam.Value("Top Over Bottom", 3)});
    private MirrorFilter filter;

    public Mirror() {
        super("Mirror");
        this.paramSet = new ParamSet(this.typeParam, this.center);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new MirrorFilter();
        }
        this.filter.setType(this.typeParam.getValue());
        this.filter.setCenterX(this.center.getRelativeX());
        this.filter.setCenterY(this.center.getRelativeY());
        this.filter.setEdgeAction(0);
        this.filter.setInterpolation(0);
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

