/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jdesktop.swingx.painter.effects.InnerGlowPathEffect;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ElevationAngleParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.painters.EffectConfigurator;
import pixelitor.tools.FgBgColorSelector;

public class RandomSpheres
extends FilterWithParametrizedGUI {
    private static final double INTUITIVE_RADIANS_45 = 5.497787143782138;
    private static final int COLORS_SAMPLE_IMAGE = 1;
    private static final int COLORS_FG_BG = 2;
    private static final int TYPE_SPHERES = 1;
    private static final int TYPE_BUBBLES = 2;
    private Random rand;
    private long seed;
    private RangeParam radiusParam = new RangeParam("Radius", 2, 100, 10);
    private RangeParam densityParam = new RangeParam("Density (%)", 1, 200, 50);
    private IntChoiceParam colorSourceParam = new IntChoiceParam("Colors Source", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Sample Image", 1), new IntChoiceParam.Value("Use FG, BG Colors", 2)});
    private IntChoiceParam typeParam = new IntChoiceParam("Type", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Spheres", 1), new IntChoiceParam.Value("Bubbles", 2)});
    private BooleanParam addHighLightsCB = new BooleanParam("Add Highlights", true);
    private AngleParam highlightAngleSelector = new AngleParam("Light Direction (Azimuth) - Degrees", 0.0);
    private ElevationAngleParam highlightElevationSelector = new ElevationAngleParam("Highlight Elevation (Degrees)", 5.497787143782138);
    private RangeParam opacityParam = new RangeParam("Opacity (%)", 0, 100, 100);
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RandomSpheres.this.reseed();
        }
    });

    public RandomSpheres() {
        super("Random Spheres");
        this.paramSet = new ParamSet(this.radiusParam, this.densityParam, this.typeParam, this.opacityParam, this.colorSourceParam, this.addHighLightsCB, this.highlightAngleSelector, this.highlightElevationSelector, this.reseedAction);
        this.seed = System.nanoTime();
        this.rand = new Random(this.seed);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        this.rand.setSeed(this.seed);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        int n3 = this.radiusParam.getValue();
        double d = this.highlightAngleSelector.getValueInRadians();
        double d2 = this.highlightElevationSelector.getValueInRadians();
        int n4 = (int)((double)n3 * Math.cos(d += Math.PI) * Math.cos(d2));
        int n5 = (int)((double)n3 * Math.sin(d) * Math.cos(d2));
        boolean bl = this.addHighLightsCB.getValue();
        float f = this.densityParam.getValueAsPercentage();
        float f2 = this.opacityParam.getValueAsPercentage();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
        int n6 = this.colorSourceParam.getValue();
        int n7 = (int)((float)(n * n2) * f / (float)(n3 * n3));
        Color[] colorArray = null;
        Color color = null;
        if (n6 == 2) {
            colorArray = new Color[]{FgBgColorSelector.getFG(), FgBgColorSelector.getBG()};
            color = colorArray[0];
        }
        int n8 = this.typeParam.getValue();
        for (int i = 0; i < n7; ++i) {
            int n9;
            int n10 = this.rand.nextInt(n);
            int n11 = bufferedImage.getRGB(n10, n9 = this.rand.nextInt(n2));
            int n12 = n11 >>> 24 & 0xFF;
            if (n12 == 0) continue;
            if (n6 == 1) {
                color = new Color(n11);
                if (bl) {
                    colorArray = new Color[]{color.brighter().brighter(), color};
                }
            }
            if (bl && n8 == 1) {
                float[] fArray = new float[]{0.0f, 1.0f};
                MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                RadialGradientPaint radialGradientPaint = new RadialGradientPaint(n10 + n4, (float)(n9 + n5), n3, fArray, colorArray, cycleMethod);
                graphics2D.setPaint(radialGradientPaint);
            } else {
                graphics2D.setColor(color);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n13 = n10 - n3;
            int n14 = n9 - n3;
            int n15 = 2 * n3;
            if (n8 == 1) {
                graphics2D.fillOval(n13, n14, n15, n15);
                continue;
            }
            if (n8 != 2) continue;
            Ellipse2D.Float float_ = new Ellipse2D.Float(n13, n14, n15, n15);
            graphics2D.draw(float_);
            InnerGlowPathEffect innerGlowPathEffect = new InnerGlowPathEffect();
            innerGlowPathEffect.setBrushColor(color);
            int n16 = n15 / 7;
            innerGlowPathEffect.setEffectWidth(n16);
            innerGlowPathEffect.setBrushSteps(EffectConfigurator.calculateBrushSteps(n16));
            innerGlowPathEffect.apply(graphics2D, float_, 0, 0);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private void reseed() {
        this.seed = System.nanoTime();
    }
}

