/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import pixelitor.AppLogic;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.layers.ImageLayer;
import pixelitor.utils.Utils;

public class TransformLayer
extends FilterWithParametrizedGUI {
    private ImagePositionParam centerParam = new ImagePositionParam("Center");
    private AngleParam angleParam = new AngleParam("Rotate Angle", 0.0);
    private ColorParam bgColorParam = new ColorParam("Background Color:", Utils.TRANSPARENT_COLOR, true, false);
    private CoupledRangeParam scaleParam = new CoupledRangeParam("Scale (%)", 1, 500, 100);
    private CoupledRangeParam shearParam = new CoupledRangeParam("Shear", -500, 500, 0);

    public TransformLayer() {
        super("Transform Layer");
        this.paramSet = new ParamSet(this.centerParam, this.angleParam, this.scaleParam, this.shearParam, this.bgColorParam);
        this.shearParam.setCoupled(false);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setColor(this.bgColorParam.getColor());
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        double d = this.angleParam.getValueInRadians();
        ImageLayer imageLayer = AppLogic.getActiveComp().getActiveImageLayer();
        float f = this.centerParam.getRelativeX();
        float f2 = this.centerParam.getRelativeY();
        double d2 = (float)(-imageLayer.getTranslationX() + bufferedImage.getWidth()) * f;
        double d3 = (float)(-imageLayer.getTranslationY() + bufferedImage.getHeight()) * f2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
        int n = this.scaleParam.getFirstValue();
        int n2 = this.scaleParam.getSecondValue();
        if (n != 100 || n2 != 100) {
            affineTransform.translate(d2, d3);
            affineTransform.scale((double)n / 100.0, (double)n2 / 100.0);
            affineTransform.translate(-d2, -d3);
        }
        int n3 = this.shearParam.getFirstValue();
        int n4 = this.shearParam.getSecondValue();
        if (n3 != 0 || n4 != 0) {
            affineTransform.translate(d2, d3);
            affineTransform.shear((double)n3 / 100.0, (double)n4 / 100.0);
            affineTransform.translate(-d2, -d3);
        }
        graphics2D.drawImage(bufferedImage, affineTransform, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

