/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import pixelitor.filters.gui.AbstractAngleSelectorComponent;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.AngleSelector;
import pixelitor.filters.gui.AngleSelectorComponent;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.Utils;

public class AngleParam
extends AbstractGUIParam {
    private double angleInRadians;
    private double defaultInRadians = 0.0;
    private transient ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();

    public AngleParam(String string, double d) {
        super(string);
        this.dontTrigger = true;
        this.setValueInRadians(d);
        this.dontTrigger = false;
        this.defaultInRadians = d;
    }

    public void setValueInDegrees(int n, boolean bl) {
        int n2 = n;
        n2 = n2 < 0 ? -n2 : 360 - n2;
        double d = Math.toRadians(n2);
        this.setValueInRadians(d, bl);
    }

    public void setValueInRadians(double d) {
        if (this.angleInRadians != d) {
            this.angleInRadians = d;
            this.fireStateChanged();
        }
        if (!this.dontTrigger && this.adjustmentListener != null) {
            this.adjustmentListener.paramAdjusted();
        }
    }

    public void setValueInRadians(double d, boolean bl) {
        this.dontTrigger = !bl;
        this.setValueInRadians(d);
    }

    public int getValueInNonIntuitiveDegrees() {
        int n = (int)Math.toDegrees(this.angleInRadians);
        return n;
    }

    public int getValueInDegrees() {
        int n = (int)Math.toDegrees(this.angleInRadians);
        n = n <= 0 ? -n : 360 - n;
        return n;
    }

    public double getValueInRadians() {
        return this.angleInRadians;
    }

    public double getValueInIntuitiveRadians() {
        return Utils.transformAtanAngleToIntuitive(this.angleInRadians);
    }

    @Override
    public boolean isSetToDefault() {
        return this.angleInRadians == this.defaultInRadians;
    }

    @Override
    public JComponent createGUI() {
        return new AngleSelector(this);
    }

    @Override
    public int getNrOfGridBagCols() {
        return 1;
    }

    private void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setValueInRadians(this.defaultInRadians);
        this.dontTrigger = false;
    }

    @Override
    public void randomize() {
        this.dontTrigger = true;
        double d = Math.random();
        this.setValueInRadians(d * 2.0 * Math.PI - Math.PI);
        this.dontTrigger = false;
    }

    public AbstractAngleSelectorComponent getAngleSelectorComponent() {
        return new AngleSelectorComponent(this);
    }

    public int getMaxAngleInDegrees() {
        return 360;
    }

    public RangeParam createRangeParam() {
        RangeParam rangeParam = new RangeParam(this.getName(), 0, this.getMaxAngleInDegrees(), this.getValueInDegrees()){

            @Override
            public void reset(boolean bl) {
                if (AngleParam.this.angleInRadians != AngleParam.this.defaultInRadians) {
                    AngleParam.this.reset(bl);
                }
            }
        };
        return rangeParam;
    }
}

