/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.filters.gui.AbstractAngleSelectorComponent;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.SliderSpinner;

public class AngleSelector
extends JPanel {
    private boolean userChangedSpinner = true;

    public AngleSelector(final AngleParam angleParam) {
        this.setLayout(new BorderLayout(10, 0));
        final AbstractAngleSelectorComponent abstractAngleSelectorComponent = angleParam.getAngleSelectorComponent();
        this.add((Component)abstractAngleSelectorComponent, "West");
        final RangeParam rangeParam = angleParam.createRangeParam();
        SliderSpinner sliderSpinner = new SliderSpinner(rangeParam, true, SliderSpinner.TextPosition.NONE);
        sliderSpinner.setResettable(angleParam);
        int n = angleParam.getMaxAngleInDegrees();
        if (n == 360) {
            sliderSpinner.setupTicks(180, 90);
        } else if (n == 90) {
            sliderSpinner.setupTicks(15, 0);
        }
        this.add((Component)sliderSpinner, "Center");
        angleParam.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                abstractAngleSelectorComponent.repaint();
                AngleSelector.this.userChangedSpinner = false;
                rangeParam.setValue(angleParam.getValueInDegrees());
                AngleSelector.this.userChangedSpinner = true;
            }
        });
        rangeParam.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AngleSelector.this.userChangedSpinner) {
                    boolean bl = !rangeParam.getValueIsAdjusting();
                    int n = rangeParam.getValue();
                    angleParam.setValueInDegrees(n, bl);
                }
            }
        });
        this.setBorder(BorderFactory.createTitledBorder(angleParam.getName()));
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = sliderSpinner.getPreferredSize();
        this.setPreferredSize(new Dimension(dimension2.width, dimension.height));
    }
}

