/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import javax.swing.JComponent;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.BooleanSelector;
import pixelitor.filters.gui.ParamGUI;

public class BooleanParam
extends AbstractGUIParam {
    private boolean defaultValue;
    private boolean currentValue;
    private boolean ignoreRandomize;
    private ParamGUI paramGUI;

    public BooleanParam(String string, boolean bl) {
        this(string, bl, false);
    }

    public BooleanParam(String string, boolean bl, boolean bl2) {
        super(string);
        this.defaultValue = bl;
        this.currentValue = bl;
        this.ignoreRandomize = bl2;
    }

    public static BooleanParam createParamForHPSharpening() {
        return new BooleanParam("High-Pass Sharpening", false, true);
    }

    public static BooleanParam createParamForShowOriginal() {
        return new BooleanParam("Show Original", false, true);
    }

    @Override
    public boolean isSetToDefault() {
        return this.defaultValue == this.currentValue;
    }

    @Override
    public JComponent createGUI() {
        BooleanSelector booleanSelector = new BooleanSelector(this);
        this.paramGUI = booleanSelector;
        return booleanSelector;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setValue(this.defaultValue, true);
        this.dontTrigger = false;
    }

    @Override
    public int getNrOfGridBagCols() {
        return 2;
    }

    @Override
    public void randomize() {
        if (!this.ignoreRandomize) {
            this.dontTrigger = true;
            this.setValue(Math.random() > 0.5, true);
            this.dontTrigger = false;
        }
    }

    public boolean getValue() {
        return this.currentValue;
    }

    public void setValue(boolean bl, boolean bl2) {
        if (this.currentValue != bl) {
            this.currentValue = bl;
            if (!this.dontTrigger) {
                this.adjustmentListener.paramAdjusted();
            }
        }
        if (bl2 && this.paramGUI != null) {
            this.paramGUI.updateGUI();
        }
    }
}

