/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.Color;
import javax.swing.JComponent;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.ColorSelector;
import pixelitor.filters.gui.ParamGUI;
import pixelitor.utils.ImageUtils;

public class ColorParam
extends AbstractGUIParam {
    private Color defaultColor;
    private Color color;
    private ParamGUI paramGUI;
    private boolean allowOpacity = false;
    private boolean allowOpacityAtRandomize;

    public ColorParam(String string, Color color, boolean bl, boolean bl2) {
        super(string);
        if (bl2 && !bl) {
            throw new IllegalArgumentException();
        }
        this.defaultColor = color;
        this.color = color;
        this.allowOpacity = bl;
        this.allowOpacityAtRandomize = bl2;
    }

    @Override
    public boolean isSetToDefault() {
        return this.color.equals(this.defaultColor);
    }

    @Override
    public JComponent createGUI() {
        ColorSelector colorSelector = new ColorSelector(this);
        this.paramGUI = colorSelector;
        return colorSelector;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setColor(this.defaultColor);
        this.dontTrigger = false;
    }

    @Override
    public int getNrOfGridBagCols() {
        return 2;
    }

    @Override
    public void randomize() {
        Color color = ImageUtils.getRandomColor(this.allowOpacityAtRandomize);
        this.dontTrigger = true;
        this.setColor(color);
        this.dontTrigger = false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("newColor is null");
        }
        if (!this.color.equals(color)) {
            this.color = color;
            if (this.paramGUI != null) {
                this.paramGUI.updateGUI();
            }
            if (!this.dontTrigger && this.adjustmentListener != null) {
                this.adjustmentListener.paramAdjusted();
            }
        }
    }

    public boolean allowOpacity() {
        return this.allowOpacity;
    }
}

