/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.filters.Filter;
import pixelitor.filters.gui.AdjustDialog;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.layers.Layers;

public abstract class FilterWithGUI
extends Filter {
    private String name;

    protected FilterWithGUI(String string) {
        this(string, null);
    }

    protected FilterWithGUI(String string, Icon icon) {
        super(string + "...", icon);
        this.name = string;
    }

    public abstract AdjustPanel getAdjustPanel();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!Layers.activeIsImageLayer()) {
            ExceptionHandler.showNotImageLayerDialog();
            return;
        }
        Composition composition = AppLogic.getActiveComp();
        if (composition != null) {
            composition.getActiveImageLayer().startPreviewing();
            AdjustPanel adjustPanel = this.getAdjustPanel();
            this.startDialogSession();
            AdjustDialog.showDialog(adjustPanel, this);
            this.endDialogSession();
        }
    }

    public void startDialogSession() {
    }

    public void endDialogSession() {
    }
}

