/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import com.bric.swing.GradientSlider;
import com.jhlabs.image.Colormap;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.utils.ImageUtils;

public class GradientParam
extends AbstractGUIParam {
    private GradientSlider gradientSlider;
    private float[] defaultThumbPositions;
    private Color[] defaultColors;

    public GradientParam(String string, Color color, Color color2) {
        this(string, new float[]{0.0f, 1.0f}, new Color[]{color, color2});
    }

    public GradientParam(String string, float[] fArray, Color[] colorArray) {
        super(string);
        this.defaultThumbPositions = fArray;
        this.defaultColors = colorArray;
        this.gradientSlider = new GradientSlider(0, fArray, colorArray);
        this.gradientSlider.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string;
                if (!(GradientParam.this.dontTrigger || GradientParam.this.gradientSlider.isValueAdjusting() || GradientParam.this.adjustmentListener == null || "ancestor".equals(string = propertyChangeEvent.getPropertyName()) || "selected thumb".equals(string))) {
                    GradientParam.this.adjustmentListener.paramAdjusted();
                }
            }
        });
        this.gradientSlider.putClientProperty("GradientSlider.useBevel", "true");
        this.gradientSlider.setPreferredSize(new Dimension(250, 30));
    }

    @Override
    public JComponent createGUI() {
        return this.gradientSlider;
    }

    public Colormap getValue() {
        return new Colormap(){

            @Override
            public int getColor(float f) {
                Color color = (Color)GradientParam.this.gradientSlider.getValue(f);
                return color.getRGB();
            }
        };
    }

    @Override
    public int getNrOfGridBagCols() {
        return 2;
    }

    @Override
    public void randomize() {
        Object[] objectArray = new Color[this.defaultThumbPositions.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ImageUtils.getRandomColor(false);
        }
        this.dontTrigger = true;
        this.gradientSlider.setValues(this.defaultThumbPositions, objectArray);
        this.dontTrigger = false;
    }

    @Override
    public boolean isSetToDefault() {
        int n;
        Color[] colorArray = (Color[])this.gradientSlider.getValues();
        if (colorArray.length != this.defaultColors.length) {
            return false;
        }
        float[] fArray = this.gradientSlider.getThumbPositions();
        for (n = 0; n < fArray.length; ++n) {
            float f = fArray[n];
            float f2 = this.defaultThumbPositions[n];
            if (f == f2) continue;
            return false;
        }
        for (n = 0; n < this.defaultColors.length; ++n) {
            Color color = this.defaultColors[n];
            Color color2 = colorArray[n];
            if (color.equals(color2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.gradientSlider.setValues(this.defaultThumbPositions, this.defaultColors);
        this.dontTrigger = false;
    }
}

