/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.IntChoiceSelector;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;

public class IntChoiceParam
extends AbstractListModel
implements ComboBoxModel,
GUIParam {
    private String name;
    private List<Value> choicesList = new ArrayList<Value>();
    private Value defaultChoice;
    private Value currentChoice;
    private ParamAdjustmentListener adjustmentListener;
    private boolean dontTrigger = false;
    private boolean ignoreRandomize;
    public static final Value EDGE_CLAMP = new Value("Repeat Edge Pixels", 1);
    private static Value[] edgeActions = new Value[]{new Value("Wrap Around", 2), EDGE_CLAMP, new Value("Transparent", 0)};
    private static Value[] interpolationChoices = new Value[]{new Value("Bilinear (Better)", 1), new Value("Nearest Neighbour (Faster)", 0)};
    private static Value[] gridTypeChoices = new Value[]{new Value("Random", 0), new Value("Squares", 1), new Value("Hexagons", 2), new Value("Octagons & Squares", 3), new Value("Triangles", 4)};

    public IntChoiceParam(String string, Value[] valueArray) {
        this(string, valueArray, false);
    }

    public IntChoiceParam(String string, Value[] valueArray, boolean bl) {
        this.ignoreRandomize = bl;
        this.name = string;
        this.choicesList.addAll(Arrays.asList(valueArray));
        this.currentChoice = this.defaultChoice = valueArray[0];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSetToDefault() {
        return this.defaultChoice.equals(this.currentChoice);
    }

    @Override
    public JComponent createGUI() {
        IntChoiceSelector intChoiceSelector = new IntChoiceSelector(this);
        return intChoiceSelector;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setSelectedItem(this.defaultChoice);
        this.dontTrigger = false;
    }

    @Override
    public void setAdjustmentListener(ParamAdjustmentListener paramAdjustmentListener) {
        this.adjustmentListener = paramAdjustmentListener;
    }

    @Override
    public int getNrOfGridBagCols() {
        return 2;
    }

    @Override
    public void randomize() {
        if (!this.ignoreRandomize) {
            Random random = new Random();
            int n = random.nextInt(this.choicesList.size());
            this.dontTrigger = true;
            this.setCurrentChoice(this.choicesList.get(n));
            this.dontTrigger = false;
        }
    }

    public int getValue() {
        return this.currentChoice.getIntValue();
    }

    public void setCurrentChoice(Value value) {
        this.setSelectedItem(value);
    }

    public void setDefaultChoice(Value value) {
        this.defaultChoice = value;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (!this.currentChoice.equals(object)) {
            this.currentChoice = (Value)object;
            this.fireContentsChanged(this, -1, -1);
            if (!this.dontTrigger && this.adjustmentListener != null) {
                this.adjustmentListener.paramAdjusted();
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.currentChoice;
    }

    @Override
    public int getSize() {
        return this.choicesList.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.choicesList.get(n);
    }

    public static IntChoiceParam getEdgeActionChoices() {
        return new IntChoiceParam("Edge Action", edgeActions);
    }

    public static IntChoiceParam getInterpolationChoices() {
        return new IntChoiceParam("Interpolation", interpolationChoices);
    }

    public static IntChoiceParam getGridTypeChoices(String string, final RangeParam rangeParam) {
        rangeParam.setEnabled(false);
        final IntChoiceParam intChoiceParam = new IntChoiceParam(string, gridTypeChoices);
        intChoiceParam.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                int n = intChoiceParam.getValue();
                rangeParam.setEnabled(n != 0);
            }
        });
        return intChoiceParam;
    }

    @Override
    protected void fireContentsChanged(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(object, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    @Override
    public void setDontTrigger(boolean bl) {
        this.dontTrigger = bl;
    }

    public static class Value {
        private int intValue;
        private String description;

        public Value(String string, int n) {
            this.description = string;
            this.intValue = n;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Value value = (Value)object;
            if (this.intValue != value.intValue) {
                return false;
            }
            return !(this.description == null ? value.description != null : !this.description.equals(value.description));
        }

        public int hashCode() {
            int n = this.intValue;
            n = 31 * n + (this.description != null ? this.description.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.description;
        }
    }
}

