/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.FlowLayout;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.filters.gui.ParamAdjustmentListener;

public class TextParam
extends AbstractGUIParam {
    private String defaultValue;
    private JTextField tf;

    public TextParam(String string, String string2) {
        super(string);
        this.defaultValue = string2;
        this.tf = new JTextField(string2);
    }

    @Override
    public boolean isSetToDefault() {
        return this.defaultValue.equals(this.getValue());
    }

    @Override
    public JComponent createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(this.getName() + ": "));
        if (this.adjustmentListener != null) {
            this.tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!TextParam.this.dontTrigger) {
                        TextParam.this.adjustmentListener.paramAdjusted();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (!TextParam.this.dontTrigger) {
                        TextParam.this.adjustmentListener.paramAdjusted();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (!TextParam.this.dontTrigger) {
                        TextParam.this.adjustmentListener.paramAdjusted();
                    }
                }
            });
        }
        jPanel.add(this.tf);
        return jPanel;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setValue(this.defaultValue);
        this.dontTrigger = false;
    }

    @Override
    public void setAdjustmentListener(ParamAdjustmentListener paramAdjustmentListener) {
        this.adjustmentListener = paramAdjustmentListener;
    }

    @Override
    public int getNrOfGridBagCols() {
        return 1;
    }

    @Override
    public void randomize() {
        this.dontTrigger = true;
        this.setValue(new Date().toString());
        this.dontTrigger = false;
    }

    public String getValue() {
        return this.tf.getText();
    }

    public void setValue(String string) {
        this.tf.setText(string);
    }
}

