/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.impl;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class MagnifyFilter
extends TransformFilter {
    private float centerX;
    private float centerY;
    private float radius;
    private float magnification;
    private float radiusRatio;
    private int cx;
    private int cy;

    public void setCenterX(float f) {
        this.centerX = f;
    }

    public void setCenterY(float f) {
        this.centerY = f;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setMagnification(float f) {
        this.magnification = f;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.cx = (int)(this.centerX * (float)bufferedImage.getWidth());
        this.cy = (int)(this.centerY * (float)bufferedImage.getHeight());
        this.radiusRatio = 1.0f / this.magnification;
        return super.filter(bufferedImage, bufferedImage2);
    }

    @Override
    protected void transformInverse(int n, int n2, float[] fArray) {
        int n3 = n - this.cx;
        int n4 = n2 - this.cy;
        int n5 = n3 * n3 + n4 * n4;
        if ((float)n5 > this.radius * this.radius) {
            fArray[0] = n;
            fArray[1] = n2;
            return;
        }
        fArray[0] = this.radiusRatio * (float)n + (1.0f - this.radiusRatio) * (float)this.cx;
        fArray[1] = this.radiusRatio * (float)n2 + (1.0f - this.radiusRatio) * (float)this.cy;
    }
}

