/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.EdgeFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.Invert;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;

public class JHConvolutionEdge
extends FilterWithParametrizedGUI {
    private IntChoiceParam horizontalMethod = new IntChoiceParam("Horizontal Edges", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Sobel", 1), new IntChoiceParam.Value("Prewitt", 2), new IntChoiceParam.Value("Roberts", 3), new IntChoiceParam.Value("Frei-Chen", 4), new IntChoiceParam.Value("None", 5)});
    private IntChoiceParam verticalMethod = new IntChoiceParam("Vertical Edges", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Sobel", 1), new IntChoiceParam.Value("Prewitt", 2), new IntChoiceParam.Value("Roberts", 3), new IntChoiceParam.Value("Frei-Chen", 4), new IntChoiceParam.Value("None", 5)});
    private BooleanParam invertImage = new BooleanParam("Invert", false, true);
    private EdgeFilter filter;
    private static final int METHOD_SOBEL = 1;
    private static final int METHOD_PREWITT = 2;
    private static final int METHOD_ROBERTS = 3;
    private static final int METHOD_FREI_CHEN = 4;
    private static final int METHOD_NONE = 5;
    private static final float[] NONE_MATRIX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public JHConvolutionEdge() {
        super("Convolution Edge Detection");
        this.paramSet = new ParamSet(this.horizontalMethod, this.verticalMethod, this.invertImage);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new EdgeFilter();
        }
        int n = this.horizontalMethod.getValue();
        switch (n) {
            case 1: {
                this.filter.setHEdgeMatrix(EdgeFilter.SOBEL_H);
                break;
            }
            case 2: {
                this.filter.setHEdgeMatrix(EdgeFilter.PREWITT_H);
                break;
            }
            case 3: {
                this.filter.setHEdgeMatrix(EdgeFilter.ROBERTS_H);
                break;
            }
            case 4: {
                this.filter.setHEdgeMatrix(EdgeFilter.FREI_CHEN_H);
                break;
            }
            case 5: {
                this.filter.setHEdgeMatrix(NONE_MATRIX);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n2 = this.verticalMethod.getValue();
        switch (n2) {
            case 1: {
                this.filter.setVEdgeMatrix(EdgeFilter.SOBEL_V);
                break;
            }
            case 2: {
                this.filter.setVEdgeMatrix(EdgeFilter.PREWITT_V);
                break;
            }
            case 3: {
                this.filter.setVEdgeMatrix(EdgeFilter.ROBERTS_V);
                break;
            }
            case 4: {
                this.filter.setVEdgeMatrix(EdgeFilter.FREI_CHEN_V);
                break;
            }
            case 5: {
                this.filter.setVEdgeMatrix(NONE_MATRIX);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        if (this.invertImage.getValue()) {
            Invert.invertImage(bufferedImage2, bufferedImage2);
        }
        return bufferedImage2;
    }
}

