/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.SphereFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHFishEye
extends FilterWithSOParametrizedGUI {
    private CoupledRangeParam radius = new CoupledRangeParam("Radius", 0, 999, 200);
    private RangeParam refractionIndex = new RangeParam("Refraction Index (%)", 100, 300, 150);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private SphereFilter filter;

    public JHFishEye() {
        super("Fisheye");
        this.paramSet = new ParamSet(this.radius, this.refractionIndex, this.center, this.interpolation, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f = this.refractionIndex.getValueAsPercentage();
        int n = this.radius.getFirstValue();
        int n2 = this.radius.getSecondValue();
        if (f == 1.0f || n == 0 || n2 == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new SphereFilter();
        }
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setA(n);
        this.filter.setB(n2);
        this.filter.setRefractionIndex(f);
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

