/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.GlintFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHGlint
extends FilterWithParametrizedGUI {
    private RangeParam threshold = new RangeParam("Threshold (%)", 0, 100, 70);
    private RangeParam coverage = new RangeParam("Coverage (%)", 0, 100, 50);
    private RangeParam amount = new RangeParam("Amount (%)", 0, 100, 15);
    private RangeParam length = new RangeParam("Length", 0, 100, 20);
    private RangeParam blur = new RangeParam("Blur", 0, 20, 1);
    private GradientParam colorsParam = new GradientParam("Colors", Color.WHITE, Color.WHITE);
    private GlintFilter filter;

    public JHGlint() {
        super("Glint");
        this.paramSet = new ParamSet(this.threshold, this.coverage, this.amount, this.length, this.blur, this.colorsParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new GlintFilter();
        }
        this.filter.setThreshold(this.threshold.getValueAsPercentage());
        this.filter.setCoverage(this.coverage.getValueAsPercentage());
        this.filter.setAmount(this.amount.getValueAsPercentage());
        this.filter.setLength(this.length.getValue());
        this.filter.setBlur(this.blur.getValue());
        this.filter.setColormap(this.colorsParam.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

