/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.PinchFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHPinch
extends FilterWithSOParametrizedGUI {
    private ImagePositionParam center = new ImagePositionParam("Center");
    private RangeParam radius = new RangeParam("Radius", 1, 999, 200);
    private RangeParam twirlAngle = new RangeParam("Twirl Angle", -360, 360, 0);
    private RangeParam pinchBulgeAmount = new RangeParam("Pinch-Bulge Amount", -100, 100, 0);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private PinchFilter filter;

    public JHPinch() {
        super("Pinch, Bulge, Twirl");
        this.paramSet = new ParamSet(this.pinchBulgeAmount, this.twirlAngle, this.radius, this.center, this.edgeAction, this.interpolation, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new PinchFilter();
        }
        this.filter.setRadius(this.radius.getValue());
        this.filter.setAngle(2.0f * this.twirlAngle.getValueInRadians());
        this.filter.setAmount(-1.0f * this.pinchBulgeAmount.getValueAsPercentage());
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

