/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.QuantizeFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHQuantize
extends FilterWithParametrizedGUI {
    private RangeParam numberOfColors = new RangeParam("Number of Colors", 2, 256, 2);
    private BooleanParam dither = new BooleanParam("Dither", false);
    private BooleanParam serpentine = new BooleanParam("Serpentine", false);
    private QuantizeFilter filter;

    public JHQuantize() {
        super("Quantize");
        this.paramSet = new ParamSet(this.numberOfColors, this.dither, this.serpentine);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new QuantizeFilter();
        }
        this.filter.setNumColors(this.numberOfColors.getValue());
        this.filter.setDither(this.dither.getValue());
        this.filter.setSerpentine(this.serpentine.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

