/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.RaysFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHRays
extends FilterWithSOParametrizedGUI {
    private ImagePositionParam center = new ImagePositionParam("Light Source");
    private RangeParam rotation = new RangeParam("Twirl", -90, 90, 0);
    private RangeParam zoom = new RangeParam("Length", 0, 200, 20);
    private RangeParam opacity = new RangeParam("Opacity (%)", 0, 100, 80);
    private RangeParam strength = new RangeParam("Strength", 0, 500, 200);
    private RangeParam threshold = new RangeParam("Threshold (%)", 0, 100, 25);
    private BooleanParam raysOnly = new BooleanParam("Rays Only", false, true);
    private RaysFilter filter;

    public JHRays() {
        super("Rays");
        this.paramSet = new ParamSet(this.center, this.zoom, this.threshold, this.strength, this.opacity, this.rotation, this.raysOnly, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new RaysFilter();
        }
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setStrength(this.strength.getValueAsPercentage());
        this.filter.setRotation(this.rotation.getValueInRadians());
        this.filter.setZoom(this.zoom.getValueAsPercentage());
        this.filter.setOpacity(this.opacity.getValueAsPercentage());
        this.filter.setThreshold(this.threshold.getValueAsPercentage());
        this.filter.setRaysOnly(this.raysOnly.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

