/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.levels;

import java.awt.image.LookupTable;
import pixelitor.filters.levels.GrayScaleLookup;
import pixelitor.filters.lookup.LookupFactory;

public class RGBLookup {
    private static final int ARRAY_LENGTH = 256;
    private short[] finalRedMapping;
    private short[] finalGreenMapping;
    private short[] finalBlueMapping;

    public RGBLookup() {
        this.allocateArrays();
    }

    public RGBLookup(short[] sArray, short[] sArray2, short[] sArray3) {
        this.finalRedMapping = sArray;
        this.finalGreenMapping = sArray2;
        this.finalBlueMapping = sArray3;
    }

    public RGBLookup(GrayScaleLookup grayScaleLookup) {
        this.allocateArrays();
        for (short s = 0; s < 256; s = (short)(s + 1)) {
            short s2;
            this.finalRedMapping[s] = s2 = grayScaleLookup.mapValue(s);
            this.finalGreenMapping[s] = s2;
            this.finalBlueMapping[s] = s2;
        }
    }

    public RGBLookup(GrayScaleLookup grayScaleLookup, GrayScaleLookup grayScaleLookup2, GrayScaleLookup grayScaleLookup3, GrayScaleLookup grayScaleLookup4, GrayScaleLookup grayScaleLookup5, GrayScaleLookup grayScaleLookup6, GrayScaleLookup grayScaleLookup7) {
        this.allocateArrays();
        for (short s = 0; s < 256; s = (short)(s + 1)) {
            short s2;
            this.finalRedMapping[s] = s2 = grayScaleLookup.mapValue(s);
            this.finalRedMapping[s] = grayScaleLookup2.mapValue(this.finalRedMapping[s]);
            this.finalRedMapping[s] = grayScaleLookup5.mapValue(this.finalRedMapping[s]);
            this.finalRedMapping[s] = grayScaleLookup6.mapValue(this.finalRedMapping[s]);
            this.finalGreenMapping[s] = s2;
            this.finalGreenMapping[s] = grayScaleLookup3.mapValue(this.finalGreenMapping[s]);
            this.finalGreenMapping[s] = grayScaleLookup5.mapValue(this.finalGreenMapping[s]);
            this.finalGreenMapping[s] = grayScaleLookup7.mapValue(this.finalGreenMapping[s]);
            this.finalBlueMapping[s] = s2;
            this.finalBlueMapping[s] = grayScaleLookup4.mapValue(this.finalBlueMapping[s]);
            this.finalBlueMapping[s] = grayScaleLookup6.mapValue(this.finalBlueMapping[s]);
            this.finalBlueMapping[s] = grayScaleLookup7.mapValue(this.finalBlueMapping[s]);
        }
    }

    private void allocateArrays() {
        this.finalRedMapping = new short[256];
        this.finalGreenMapping = new short[256];
        this.finalBlueMapping = new short[256];
    }

    public int mapRGBValue(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = this.finalRedMapping[n3];
        n4 = this.finalGreenMapping[n4];
        n5 = this.finalBlueMapping[n5];
        n = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return n;
    }

    public LookupTable getLookupOp() {
        return LookupFactory.createLookupFrom3Arrays(this.finalRedMapping, this.finalGreenMapping, this.finalBlueMapping);
    }

    public void initFromPosterize(int n) {
        for (int i = 0; i < 256; ++i) {
            int n2 = 255 * (n * i / 256) / (n - 1);
            this.finalRedMapping[i] = (short)n2;
            this.finalGreenMapping[i] = (short)n2;
            this.finalBlueMapping[i] = (short)n2;
        }
    }
}

