/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import java.awt.Color;
import java.awt.Container;
import java.awt.geom.Point2D;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.AngleSelectorComponent;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.painters.EffectConfigurator;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.SliderSpinner;
import pixelitor.utils.Utils;

public class DropShadowEffectConfigurator
extends EffectConfigurator {
    private AngleParam angleParam = new AngleParam("Angle", 0.7);
    private RangeParam distanceParam;

    DropShadowEffectConfigurator(boolean bl, Color color, int n) {
        super("Drop Shadow", bl, color, n, "Spread:");
        AngleSelectorComponent angleSelectorComponent = new AngleSelectorComponent(this.angleParam);
        GridBagHelper.addLabel((Container)this, "Angle:", 0, 3);
        GridBagHelper.addControl(this, angleSelectorComponent);
        this.distanceParam = new RangeParam("Distance:", 1, 100, 10);
        SliderSpinner sliderSpinner = new SliderSpinner(this.distanceParam, false, SliderSpinner.TextPosition.NONE);
        GridBagHelper.addLabel((Container)this, "Distance:", 0, 4);
        GridBagHelper.addControl(this, sliderSpinner);
    }

    @Override
    public void setAdjustmentListener(ParamAdjustmentListener paramAdjustmentListener) {
        super.setAdjustmentListener(paramAdjustmentListener);
        this.angleParam.setAdjustmentListener(paramAdjustmentListener);
        this.distanceParam.setAdjustmentListener(paramAdjustmentListener);
    }

    public Point2D getOffset() {
        int n = this.distanceParam.getValue();
        double d = this.angleParam.getValueInRadians();
        return Utils.calculateOffset(n, d);
    }
}

