/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import com.bric.util.JVM;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.painters.EffectsPanel;
import pixelitor.filters.painters.TextFilter;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.SliderSpinner;

public class TextFilterAdjustments
extends AdjustPanel
implements ParamAdjustmentListener,
ActionListener {
    private JTextField textTF;
    private JComboBox fontFamilyChooserCB;
    private SliderSpinner fontSizeSlider;
    private JCheckBox boldCB;
    private JCheckBox italicCB;
    private JCheckBox underlineCB;
    private JCheckBox strikeThroughCB;
    private EffectsPanel effectsPanel;
    private JComboBox verticalAlignmentCombo;
    private JComboBox horizontalAlignmentCombo;
    private JCheckBox watermarkCB;

    public TextFilterAdjustments(TextFilter textFilter) {
        super(textFilter);
        Box box = Box.createVerticalBox();
        box.add(this.createTextPanel());
        box.add(this.createFontPanel());
        if (!JVM.isLinux) {
            this.effectsPanel = new EffectsPanel(this);
            this.effectsPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
            box.add(this.effectsPanel);
        }
        this.watermarkCB = new JCheckBox("Use Text for Watermarking");
        this.watermarkCB.addActionListener(this);
        box.add(this.watermarkCB);
        this.add(box);
    }

    private JPanel createTextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)jPanel, "Text:", 0, 0);
        this.textTF = new JTextField(20);
        this.textTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextFilterAdjustments.this.paramAdjusted();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextFilterAdjustments.this.paramAdjusted();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextFilterAdjustments.this.paramAdjusted();
            }
        });
        GridBagHelper.addLastControl(jPanel, this.textTF);
        GridBagHelper.addLabel((Container)jPanel, "Vertical Alignment", 0, 1);
        this.verticalAlignmentCombo = new JComboBox<AbstractLayoutPainter.VerticalAlignment>(AbstractLayoutPainter.VerticalAlignment.values());
        this.verticalAlignmentCombo.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.verticalAlignmentCombo);
        GridBagHelper.addLabel((Container)jPanel, "Horizontal Alignment", 2, 1);
        this.horizontalAlignmentCombo = new JComboBox<AbstractLayoutPainter.HorizontalAlignment>(AbstractLayoutPainter.HorizontalAlignment.values());
        this.horizontalAlignmentCombo.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.horizontalAlignmentCombo);
        return jPanel;
    }

    private JPanel createFontPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)jPanel, "Font Size:", 0, 0);
        RangeParam rangeParam = new RangeParam("", 1, 400, 50);
        this.fontSizeSlider = new SliderSpinner(rangeParam, false, SliderSpinner.TextPosition.NONE);
        rangeParam.setAdjustmentListener(this);
        GridBagHelper.addLastControl(jPanel, this.fontSizeSlider);
        GridBagHelper.addLabel((Container)jPanel, "Font Type:", 0, 1);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.fontFamilyChooserCB = new JComboBox<String>(stringArray);
        this.fontFamilyChooserCB.addActionListener(this);
        GridBagHelper.addLastControl(jPanel, this.fontFamilyChooserCB);
        GridBagHelper.addLabel((Container)jPanel, "Bold:", 0, 2);
        this.boldCB = new JCheckBox();
        this.boldCB.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.boldCB);
        GridBagHelper.addLabel((Container)jPanel, "Italic:", 2, 2);
        this.italicCB = new JCheckBox();
        this.italicCB.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.italicCB);
        GridBagHelper.addLabel((Container)jPanel, "Underline:", 4, 2);
        this.underlineCB = new JCheckBox();
        this.underlineCB.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.underlineCB);
        GridBagHelper.addLabel((Container)jPanel, "Strikethrough:", 6, 2);
        this.strikeThroughCB = new JCheckBox();
        this.strikeThroughCB.addActionListener(this);
        GridBagHelper.addControl(jPanel, this.strikeThroughCB);
        return jPanel;
    }

    private Font getSelectedFont() {
        String string = (String)this.fontFamilyChooserCB.getSelectedItem();
        int n = 0;
        if (this.boldCB.isSelected()) {
            n |= 1;
        }
        if (this.italicCB.isSelected()) {
            n |= 2;
        }
        int n2 = this.fontSizeSlider.getCurrentValue();
        Font font = new Font(string, n, n2);
        Hashtable<TextAttribute, Constable> hashtable = new Hashtable<TextAttribute, Constable>();
        if (this.underlineCB.isSelected()) {
            hashtable.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.strikeThroughCB.isSelected()) {
            hashtable.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return font.deriveFont(hashtable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.paramAdjusted();
    }

    @Override
    public void paramAdjusted() {
        TextFilter textFilter = (TextFilter)this.op;
        textFilter.setText(this.textTF.getText());
        textFilter.setFont(this.getSelectedFont());
        if (this.effectsPanel != null) {
            this.effectsPanel.updateEffectsFromGUI();
            AreaEffect[] areaEffectArray = this.effectsPanel.getEffectsAsArray();
            textFilter.setAreaEffects(areaEffectArray);
        }
        textFilter.setWatermark(this.watermarkCB.isSelected());
        textFilter.setVerticalAlignment((AbstractLayoutPainter.VerticalAlignment)((Object)this.verticalAlignmentCombo.getSelectedItem()));
        textFilter.setHorizontalAlignment((AbstractLayoutPainter.HorizontalAlignment)((Object)this.horizontalAlignmentCombo.getSelectedItem()));
        super.executeFilterPreview();
    }
}

