/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.Layer;

public class LayerOpacityEdit
extends PixelitorEdit {
    private Layer layer;
    private float backupOpacity;

    public LayerOpacityEdit(Layer layer, float f) {
        super(layer.getComposition(), "Layer Opacity Change");
        this.layer = layer;
        this.backupOpacity = f;
        layer.getComposition().setDirty(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapOpacity();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapOpacity();
    }

    private void swapOpacity() {
        float f = this.layer.getOpacity();
        this.layer.setOpacity(this.backupOpacity, true, false);
        this.backupOpacity = f;
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

