/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.Layer;

public class LayerVisibilityChangeEdit
extends PixelitorEdit {
    private Layer layer;
    private boolean newVisibility;

    public LayerVisibilityChangeEdit(Composition composition, Layer layer, boolean bl) {
        super(composition, bl ? "Show Layer" : "Hide Layer");
        this.newVisibility = bl;
        this.layer = layer;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.layer.setVisible(!this.newVisibility, false);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.layer.setVisible(this.newVisibility, false);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

