/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.io.OpenSaveManager;

public class DropListener
extends DropTargetAdapter {
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                return;
            }
            if (!dataFlavor.isFlavorJavaFileListType()) continue;
            dropTargetDropEvent.acceptDrop(1);
            try {
                List list = (List)transferable.getTransferData(dataFlavor);
                for (File file : list) {
                    if (file.isDirectory()) {
                        int n = JOptionPane.showConfirmDialog(PixelitorWindow.getInstance(), "You have dropped the folder \"" + file.getName() + "\". Do you want to open all image files inside it?", "Question", 0, 3);
                        if (n == 0) {
                            OpenSaveManager.openAllImagesInDir(file);
                            continue;
                        }
                        if (n != 1) continue;
                    }
                    if (!file.isFile()) continue;
                    OpenSaveManager.openFile(file);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ExceptionHandler.showExceptionDialog(unsupportedFlavorException);
                dropTargetDropEvent.rejectDrop();
            }
            catch (IOException iOException) {
                ExceptionHandler.showExceptionDialog(iOException);
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        dropTargetDropEvent.rejectDrop();
    }
}

