/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.ImageComponent;
import pixelitor.PixelitorWindow;
import pixelitor.automate.SingleDirChooserPanel;
import pixelitor.io.FileExtensionUtils;
import pixelitor.io.JpegOutput;
import pixelitor.io.NotPxcFormatException;
import pixelitor.io.OutputFormat;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.menus.RecentFilesMenu;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.CustomFileChooser;
import pixelitor.utils.ImagePreviewPanel;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.Utils;

public class OpenSaveManager {
    private static JFileChooser openFileChooser;
    private static CustomFileChooser saveFileChooser;
    private static File lastOpenDir;
    private static File lastSaveDir;
    private static final float DEFAULT_JPEG_QUALITY = 0.87f;
    private static float jpegQuality;

    private OpenSaveManager() {
    }

    public static synchronized void initOpenFileChooser() {
        if (openFileChooser == null) {
            openFileChooser = new JFileChooser(lastOpenDir);
            FileExtensionUtils.addOpenFilters(openFileChooser);
            ImagePreviewPanel imagePreviewPanel = new ImagePreviewPanel();
            openFileChooser.setAccessory(imagePreviewPanel);
            openFileChooser.addPropertyChangeListener(imagePreviewPanel);
        }
    }

    public static synchronized void initSaveFileChooser() {
        if (saveFileChooser == null) {
            saveFileChooser = new CustomFileChooser(lastSaveDir);
            FileExtensionUtils.addSaveFilters(saveFileChooser);
        }
    }

    public static void open() {
        OpenSaveManager.initOpenFileChooser();
        int n = openFileChooser.showOpenDialog(PixelitorWindow.getInstance());
        if (n == 0) {
            File file = openFileChooser.getSelectedFile();
            String string = file.getName();
            lastOpenDir = file.getParentFile();
            if (FileExtensionUtils.isSupportedExtension(string, FileExtensionUtils.SUPPORTED_INPUT_FORMATS)) {
                OpenSaveManager.openFile(file);
            } else {
                OpenSaveManager.handleUnsupportedExtensionLoading(string);
            }
        } else if (n == 1) {
            // empty if block
        }
    }

    private static void handleUnsupportedExtensionLoading(String string) {
        String string2 = FileExtensionUtils.getFileExtension(string);
        String string3 = "Could not load " + string + ", because ";
        string3 = string2 == null ? string3 + "it has no extension." : string3 + "files of type " + string2 + " are not supported.";
        JOptionPane.showMessageDialog(PixelitorWindow.getInstance(), string3, "Error", 0);
    }

    public static void openFile(File file) {
        String string = FileExtensionUtils.getFileExtension(file.getName());
        if ("pxc".equals(string)) {
            OpenSaveManager.openComposition(file);
        } else {
            OpenSaveManager.openOneLayeredFile(file);
        }
        RecentFilesMenu.getInstance().addFile(file);
    }

    private static void openOneLayeredFile(final File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(file);
                }
                catch (IOException iOException) {
                    ExceptionHandler.showExceptionDialog(iOException);
                }
                if (bufferedImage == null) {
                    JOptionPane.showMessageDialog(PixelitorWindow.getInstance(), "Could not load \"" + file.getName() + "\" as an image file", "Error", 0);
                    return;
                }
                bufferedImage = ImageUtils.transformToCompatibleImage(bufferedImage);
                PixelitorWindow.getInstance().addNewImage(bufferedImage, file, null);
            }
        };
        Utils.executeWithBusyCursor(runnable, false);
    }

    public static void save(boolean bl) {
        try {
            Composition composition = AppLogic.getActiveComp();
            OpenSaveManager.save(composition, bl);
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    private static boolean save(Composition composition, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl || composition.getFile() == null;
        if (bl2) {
            OpenSaveManager.initSaveFileChooser();
            String string = FileExtensionUtils.getFileNameWOExtension(composition.getName());
            saveFileChooser.setSelectedFile(new File(string));
            String string2 = FileExtensionUtils.getFileExtension(composition.getName());
            saveFileChooser.setFileFilter(FileExtensionUtils.getFileFilterForExtension(string2));
            return OpenSaveManager.showSaveFileChooser(composition);
        }
        File file = composition.getFile();
        OutputFormat outputFormat = OutputFormat.valueFromFile(file);
        outputFormat.saveComposition(composition, file);
        return true;
    }

    private static boolean showSaveFileChooser(Composition composition) {
        int n = saveFileChooser.showSaveDialog(PixelitorWindow.getInstance());
        if (n == 0) {
            File file = saveFileChooser.getSelectedFile();
            lastSaveDir = file.getParentFile();
            OutputFormat outputFormat = saveFileChooser.getOutputFormat();
            outputFormat.saveComposition(composition, file);
            return true;
        }
        if (n == 1) {
            return false;
        }
        return false;
    }

    public static void saveImageToFile(final File file, final BufferedImage bufferedImage, final String string) {
        if (file == null) {
            throw new IllegalArgumentException("selectedFile is null");
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("image is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("format is null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if ("jpg".equals(string)) {
                        JpegOutput.writeJPG(bufferedImage, file, jpegQuality);
                    } else {
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                    }
                }
                catch (IOException iOException) {
                    ExceptionHandler.showExceptionDialog(iOException);
                }
            }
        };
        Utils.executeWithBusyCursor(runnable, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void warnAndCloseImage(ImageComponent imageComponent) {
        try {
            Composition composition = imageComponent.getComp();
            if (!composition.isDirty()) {
                imageComponent.close();
                return;
            }
            Object[] objectArray = new Object[]{"Save", "Don't save", "Cancel"};
            JLabel jLabel = new JLabel("<html><b>Do you want to save the changes made to " + composition.getName() + "?</b><br>Your changes will be lost if you don't save them.</html>");
            int n = JOptionPane.showOptionDialog(PixelitorWindow.getInstance(), jLabel, "Unsaved changes", 1, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                boolean bl = OpenSaveManager.save(composition, false);
                if (!bl) return;
                imageComponent.close();
                return;
            }
            if (n == 1) {
                imageComponent.close();
                return;
            }
            if (n != 2) return;
            return;
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }

    public static void warnAndCloseAllImages() {
        List<ImageComponent> list = AppLogic.getImageComponents();
        ArrayList<ImageComponent> arrayList = new ArrayList<ImageComponent>(list);
        for (ImageComponent imageComponent : arrayList) {
            OpenSaveManager.warnAndCloseImage(imageComponent);
        }
    }

    public static File getLastOpenDir() {
        return lastOpenDir;
    }

    public static File getLastSaveDir() {
        return lastSaveDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeComposition(Composition composition, File file) {
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new byte[]{-85, -60, 2});
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(composition);
        }
        catch (IOException iOException) {
            ExceptionHandler.showExceptionDialog(iOException);
        }
        finally {
            try {
                objectOutputStream.flush();
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                ExceptionHandler.showExceptionDialog(iOException);
            }
        }
    }

    private static Composition deserializeComposition(File file) throws NotPxcFormatException {
        Composition composition = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.read();
            int n2 = fileInputStream.read();
            if (n != 171 || n2 != 196) {
                throw new NotPxcFormatException(file.getName() + " is not in the pxc format.");
            }
            int n3 = fileInputStream.read();
            if (n3 == 0) {
                throw new NotPxcFormatException(file.getName() + " is in an obsolete pxc format, it can only be opened in the old beta Pixelitor versions 0.9.2-0.9.7");
            }
            if (n3 == 1) {
                throw new NotPxcFormatException(file.getName() + " is in an obsolete pxc format, it can only be opened in the old beta Pixelitor version 0.9.8");
            }
            if (n3 > 2) {
                throw new NotPxcFormatException(file.getName() + " has unknown version byte " + n3);
            }
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            composition = (Composition)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ExceptionHandler.showExceptionDialog(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.showExceptionDialog(classNotFoundException);
        }
        return composition;
    }

    private static void openComposition(final File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Composition composition = OpenSaveManager.deserializeComposition(file);
                    PixelitorWindow.getInstance().addDeserializedComposition(composition, file);
                }
                catch (NotPxcFormatException notPxcFormatException) {
                    ExceptionHandler.showExceptionDialog(notPxcFormatException);
                }
            }
        };
        Utils.executeWithBusyCursor(runnable, false);
    }

    public static void setLastOpenDir(File file) {
        lastOpenDir = file;
    }

    public static void setLastSaveDir(File file) {
        lastSaveDir = file;
    }

    public static void openAllImagesInDir(File file) {
        File[] fileArray = FileExtensionUtils.getAllSupportedFilesInDir(file);
        if (fileArray != null) {
            for (File file2 : fileArray) {
                OpenSaveManager.openFile(file2);
            }
        }
    }

    public static void exportLayersToPNG() {
        boolean bl = SingleDirChooserPanel.selectOutputDir(false);
        if (!bl) {
            return;
        }
        Composition composition = AppLogic.getActiveComp();
        int n = composition.getNrLayers();
        for (int i = 0; i < n; ++i) {
            Layer layer = composition.getLayer(i);
            if (!(layer instanceof ImageLayer)) continue;
            ImageLayer imageLayer = (ImageLayer)layer;
            BufferedImage bufferedImage = imageLayer.getBufferedImage();
            File file = OpenSaveManager.getLastSaveDir();
            String string = String.format("%03d_%s.%s", i, Utils.toFileName(layer.getName()), "png");
            File file2 = new File(file, string);
            OpenSaveManager.saveImageToFile(file2, bufferedImage, "png");
        }
    }

    public static void saveCurrentImageInAllFormats() {
        boolean bl;
        Composition composition = AppLogic.getActiveComp();
        boolean bl2 = bl = !SingleDirChooserPanel.selectOutputDir(false);
        if (bl) {
            return;
        }
        File file = OpenSaveManager.getLastSaveDir();
        if (file != null) {
            OutputFormat[] outputFormatArray;
            for (OutputFormat outputFormat : outputFormatArray = OutputFormat.values()) {
                File file2 = new File(file, "all_formats." + outputFormat.toString());
                outputFormat.saveComposition(composition, file2);
            }
        }
    }

    public static void saveAllImagesToDir() {
        boolean bl;
        boolean bl2 = bl = !SingleDirChooserPanel.selectOutputDir(true);
        if (bl) {
            return;
        }
        final OutputFormat outputFormat = OutputFormat.getLastOutputFormat();
        final File file = OpenSaveManager.getLastSaveDir();
        final List<ImageComponent> list = AppLogic.getImageComponents();
        final ProgressMonitor progressMonitor = Utils.createProgressMonitor("Saving All Images to Directory");
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                for (int i = 0; i < list.size(); ++i) {
                    progressMonitor.setProgress((int)((float)i * 100.0f / (float)list.size()));
                    if (progressMonitor.isCanceled()) break;
                    ImageComponent imageComponent = (ImageComponent)list.get(i);
                    Composition composition = imageComponent.getComp();
                    String string = String.format("%04d_%s.%s", i, Utils.toFileName(composition.getName()), outputFormat.toString());
                    File file2 = new File(file, string);
                    progressMonitor.setNote("Saving " + string);
                    outputFormat.saveComposition(composition, file2);
                }
                progressMonitor.close();
                return null;
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveJpegWithQuality(float f) {
        try {
            FileExtensionUtils.setupJPegSaveFilter(saveFileChooser);
            jpegQuality = f;
            OpenSaveManager.showSaveFileChooser(AppLogic.getActiveComp());
        }
        finally {
            FileExtensionUtils.addSaveFilters(saveFileChooser);
            jpegQuality = 0.87f;
        }
    }

    static {
        lastOpenDir = AppPreferences.loadLastOpenDir();
        lastSaveDir = AppPreferences.loadLastSaveDir();
        jpegQuality = 0.87f;
    }
}

