/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.awt.image.BufferedImage;
import java.io.File;
import pixelitor.Composition;
import pixelitor.io.FileExtensionUtils;
import pixelitor.io.OpenSaveManager;
import pixelitor.menus.RecentFilesMenu;
import pixelitor.utils.ImageUtils;

public enum OutputFormat {
    JPG{

        @Override
        public void doSaveComposition(Composition composition, File file) {
            BufferedImage bufferedImage = composition.getCompositeImage();
            BufferedImage bufferedImage2 = ImageUtils.convertToRGB(bufferedImage, false);
            OpenSaveManager.saveImageToFile(file, bufferedImage2, this.toString());
        }
    }
    ,
    PNG{

        @Override
        public void doSaveComposition(Composition composition, File file) {
            BufferedImage bufferedImage = composition.getCompositeImage();
            OpenSaveManager.saveImageToFile(file, bufferedImage, this.toString());
        }
    }
    ,
    GIF{

        @Override
        public void doSaveComposition(Composition composition, File file) {
            BufferedImage bufferedImage = composition.getCompositeImage();
            BufferedImage bufferedImage2 = ImageUtils.convertToRGB(bufferedImage, false);
            OpenSaveManager.saveImageToFile(file, bufferedImage2, this.toString());
        }
    }
    ,
    BMP{

        @Override
        public void doSaveComposition(Composition composition, File file) {
            BufferedImage bufferedImage = composition.getCompositeImage();
            BufferedImage bufferedImage2 = ImageUtils.convertToRGB(bufferedImage, false);
            OpenSaveManager.saveImageToFile(file, bufferedImage2, this.toString());
        }
    }
    ,
    PXC{

        @Override
        public void doSaveComposition(Composition composition, File file) {
            OpenSaveManager.serializeComposition(composition, file);
        }
    };

    private static OutputFormat lastOutputFormat;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static OutputFormat valueFromFile(File file) {
        String string = file.getName();
        String string2 = FileExtensionUtils.getFileExtension(string);
        return OutputFormat.valueFromExtension(string2);
    }

    public static OutputFormat valueFromExtension(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("jpg") || string2.equals("jpeg")) {
            return JPG;
        }
        if (string2.equals("png")) {
            return PNG;
        }
        if (string2.equals("bmp")) {
            return BMP;
        }
        if (string2.equals("gif")) {
            return GIF;
        }
        if (string2.equals("pxc")) {
            return PXC;
        }
        throw new IllegalArgumentException("extension = " + string);
    }

    public void saveComposition(Composition composition, File file) {
        this.doSaveComposition(composition, file);
        composition.setDirty(false);
        composition.setFile(file);
        RecentFilesMenu.getInstance().addFile(file);
    }

    abstract void doSaveComposition(Composition var1, File var2);

    public static OutputFormat getLastOutputFormat() {
        return lastOutputFormat;
    }

    public static void setLastOutputFormat(OutputFormat outputFormat) {
        lastOutputFormat = outputFormat;
    }

    static {
        lastOutputFormat = JPG;
    }
}

