/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import org.jdesktop.swingx.painter.TranslatedTextPainter;
import pixelitor.Composition;
import pixelitor.history.TranslateEdit;
import pixelitor.layers.Layer;
import pixelitor.layers.ShapeLayer;

public class TextLayer
extends ShapeLayer {
    private static final long serialVersionUID = 2L;
    private String text;
    private int startX = 20;
    private int startY = 70;
    private Font font = new Font("Comic Sans MS", 1, 42);
    private TranslatedTextPainter painter;

    public TextLayer(Composition composition, String string, String string2) {
        super(composition, string);
        this.text = string2;
        Color color = Color.WHITE;
        this.painter = new TranslatedTextPainter(string2, this.font, color);
    }

    @Override
    public Shape getShape(Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        return textLayout.getOutline(null);
    }

    @Override
    public Layer duplicate() {
        return new TextLayer(this.comp, this.getDuplicateLayerName(), this.text);
    }

    @Override
    public void moveLayerRelative(int n, int n2) {
        super.moveLayerRelative(n, n2);
        this.painter.setTranslationX(this.getTranslationX());
        this.painter.setTranslationY(this.getTranslationY());
    }

    @Override
    public void paintLayerOnGraphics(Graphics2D graphics2D, boolean bl) {
        this.setupDrawingComposite(graphics2D, bl);
        this.painter.paint(graphics2D, null, this.comp.getCanvasWidth(), this.comp.getCanvasHeight());
    }

    @Override
    TranslateEdit createTranslateEdit(int n, int n2) {
        return new TranslateEdit(this, null, n, n2);
    }
}

