/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import com.bric.util.JVM;
import com.jhlabs.composite.MultiplyComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.EnlargeCanvas;
import pixelitor.ExceptionHandler;
import pixelitor.FillType;
import pixelitor.ImageComponent;
import pixelitor.NewImage;
import pixelitor.PixelitorWindow;
import pixelitor.TipsOfTheDay;
import pixelitor.automate.BatchResize;
import pixelitor.filters.AddNoise;
import pixelitor.filters.Brick;
import pixelitor.filters.Brightness;
import pixelitor.filters.Canny;
import pixelitor.filters.ChannelInvert;
import pixelitor.filters.ChannelMixer;
import pixelitor.filters.CircleToSquare;
import pixelitor.filters.Clouds;
import pixelitor.filters.Collage;
import pixelitor.filters.Colorize;
import pixelitor.filters.DrawGrid;
import pixelitor.filters.ExtractChannel;
import pixelitor.filters.Fade;
import pixelitor.filters.FastBlur;
import pixelitor.filters.Fill;
import pixelitor.filters.FillWithColorWheel;
import pixelitor.filters.GlassTile;
import pixelitor.filters.GradientMap;
import pixelitor.filters.HueSat;
import pixelitor.filters.Invert;
import pixelitor.filters.Magnify;
import pixelitor.filters.Mirror;
import pixelitor.filters.NoDialogPixelOpFactory;
import pixelitor.filters.Orton;
import pixelitor.filters.ParamTest;
import pixelitor.filters.Posterize;
import pixelitor.filters.RandomSpheres;
import pixelitor.filters.RepeatLastOp;
import pixelitor.filters.Solarize;
import pixelitor.filters.Starburst;
import pixelitor.filters.Threshold;
import pixelitor.filters.TransformLayer;
import pixelitor.filters.ValueNoise;
import pixelitor.filters.comp.Flip;
import pixelitor.filters.comp.Rotate;
import pixelitor.filters.convolve.Convolve;
import pixelitor.filters.jhlabsproxies.JHBoxBlur;
import pixelitor.filters.jhlabsproxies.JHCaustics;
import pixelitor.filters.jhlabsproxies.JHCells;
import pixelitor.filters.jhlabsproxies.JHConvolutionEdge;
import pixelitor.filters.jhlabsproxies.JHCrystallize;
import pixelitor.filters.jhlabsproxies.JHDifferenceOfGaussians;
import pixelitor.filters.jhlabsproxies.JHDropShadow;
import pixelitor.filters.jhlabsproxies.JHDryBrush;
import pixelitor.filters.jhlabsproxies.JHEmboss;
import pixelitor.filters.jhlabsproxies.JHFishEye;
import pixelitor.filters.jhlabsproxies.JHFourColorGradient;
import pixelitor.filters.jhlabsproxies.JHFrostedGlass;
import pixelitor.filters.jhlabsproxies.JHGaussianBlur;
import pixelitor.filters.jhlabsproxies.JHGlint;
import pixelitor.filters.jhlabsproxies.JHGlow;
import pixelitor.filters.jhlabsproxies.JHKaleidoscope;
import pixelitor.filters.jhlabsproxies.JHLaplacian;
import pixelitor.filters.jhlabsproxies.JHLensBlur;
import pixelitor.filters.jhlabsproxies.JHMedian;
import pixelitor.filters.jhlabsproxies.JHMotionBlur;
import pixelitor.filters.jhlabsproxies.JHOffset;
import pixelitor.filters.jhlabsproxies.JHPinch;
import pixelitor.filters.jhlabsproxies.JHPixelate;
import pixelitor.filters.jhlabsproxies.JHPlasma;
import pixelitor.filters.jhlabsproxies.JHPointillize;
import pixelitor.filters.jhlabsproxies.JHPolarCoordinates;
import pixelitor.filters.jhlabsproxies.JHQuantize;
import pixelitor.filters.jhlabsproxies.JHRays;
import pixelitor.filters.jhlabsproxies.JHReduceNoise;
import pixelitor.filters.jhlabsproxies.JHSmartBlur;
import pixelitor.filters.jhlabsproxies.JHSmear;
import pixelitor.filters.jhlabsproxies.JHSparkle;
import pixelitor.filters.jhlabsproxies.JHStamp;
import pixelitor.filters.jhlabsproxies.JHTurbulentDistortion;
import pixelitor.filters.jhlabsproxies.JHUnsharpMask;
import pixelitor.filters.jhlabsproxies.JHVideoFeedback;
import pixelitor.filters.jhlabsproxies.JHWaterRipple;
import pixelitor.filters.jhlabsproxies.JHWaves;
import pixelitor.filters.jhlabsproxies.JHWood;
import pixelitor.filters.jhlabsproxies.JHWrapAroundArc;
import pixelitor.filters.lookup.ColorBalance;
import pixelitor.filters.lookup.Levels;
import pixelitor.filters.lookup.Luminosity;
import pixelitor.filters.painters.TextFilter;
import pixelitor.history.History;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OptimizedJpegSavePanel;
import pixelitor.layers.AddNewLayerAction;
import pixelitor.layers.AdjustmentLayer;
import pixelitor.layers.ContentLayer;
import pixelitor.layers.DeleteActiveLayerAction;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerDownAction;
import pixelitor.layers.LayerUpAction;
import pixelitor.layers.TextLayer;
import pixelitor.menus.AboutDialog;
import pixelitor.menus.CopyAction;
import pixelitor.menus.CopyType;
import pixelitor.menus.MenuEnableCondition;
import pixelitor.menus.MenuFactory;
import pixelitor.menus.PasteAction;
import pixelitor.menus.RecentFilesMenu;
import pixelitor.menus.ScreenCaptureAction;
import pixelitor.menus.SelectionActions;
import pixelitor.menus.ShowHideAllAction;
import pixelitor.menus.ShowHideHistogramsAction;
import pixelitor.menus.ShowHideLayersAction;
import pixelitor.menus.ShowHideStatusBarAction;
import pixelitor.menus.ShowHideToolsAction;
import pixelitor.menus.ZoomMenu;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.FilterCreator;
import pixelitor.utils.HistogramsPanel;
import pixelitor.utils.OpenInBrowserAction;
import pixelitor.utils.PerformanceTestingDialog;
import pixelitor.utils.test.DebugEventQueue;
import pixelitor.utils.test.ImageTests;
import pixelitor.utils.test.OpTests;
import pixelitor.utils.test.RobotTest;
import pixelitor.utils.test.ToolTests;

public class MenuBar
extends JMenuBar {
    public MenuBar(JFrame jFrame) {
        this.initFileMenu();
        this.initEditMenu();
        this.initLayerMenu();
        this.initSelectMenu();
        this.initColorsMenu();
        this.initFilterMenu();
        this.initViewMenu();
        if (Build.CURRENT != Build.FINAL) {
            this.initDevelopMenu();
        }
        this.initHelpMenu();
    }

    private void initFileMenu() {
        AbstractAction abstractAction;
        JMenu jMenu = MenuBar.createMenu("File", 'F');
        MenuFactory.createMenuItem(NewImage.getAction(), KeyStroke.getKeyStroke(78, 2), jMenu, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction2 = new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OpenSaveManager.open();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(79, 2), jMenu, MenuEnableCondition.ACTION_MANAGED);
        RecentFilesMenu recentFilesMenu = RecentFilesMenu.getInstance();
        jMenu.add(recentFilesMenu);
        AbstractAction abstractAction3 = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.save(false);
            }
        };
        MenuFactory.createMenuItem(abstractAction3, KeyStroke.getKeyStroke(83, 2), jMenu);
        AbstractAction abstractAction4 = new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.save(true);
            }
        };
        MenuFactory.createMenuItem(abstractAction4, KeyStroke.getKeyStroke(83, 3), jMenu);
        AbstractAction abstractAction5 = new AbstractAction("Optimized JPEG Save..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                BufferedImage bufferedImage = composition.getCompositeImage();
                OptimizedJpegSavePanel.showInDialog(bufferedImage, PixelitorWindow.getInstance());
            }
        };
        MenuFactory.createMenuItem(abstractAction5, null, jMenu);
        AbstractAction abstractAction6 = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.warnAndCloseImage(AppLogic.getActiveImageComponent());
            }
        };
        MenuFactory.createMenuItem(abstractAction6, KeyStroke.getKeyStroke(87, 2), jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        AbstractAction abstractAction7 = new AbstractAction("Close All"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.warnAndCloseAllImages();
            }
        };
        MenuFactory.createMenuItem(abstractAction7, KeyStroke.getKeyStroke(87, 10), jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuBar.initAutomateSubmenu(jMenu);
        if (!JVM.isMac) {
            abstractAction = new ScreenCaptureAction();
            MenuFactory.createMenuItem(abstractAction, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        }
        jMenu.addSeparator();
        abstractAction = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppLogic.exitApp();
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        this.add(jMenu);
    }

    private static void initAutomateSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Automate");
        jMenu.add(jMenu2);
        AbstractAction abstractAction = new AbstractAction("Batch Resize..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BatchResize.runBatchResize();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction2 = new AbstractAction("Export Layers to PNG..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OpenSaveManager.exportLayersToPNG();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
    }

    private void initEditMenu() {
        JMenu jMenu = MenuBar.createMenu("Edit", 'E');
        MenuFactory.createMenuItem(RepeatLastOp.INSTANCE, KeyStroke.getKeyStroke(70, 2), jMenu, MenuEnableCondition.IF_CAN_REPEAT_OPERATION);
        jMenu.addSeparator();
        AbstractAction abstractAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                History.undo();
            }
        };
        MenuFactory.createMenuItem(abstractAction, KeyStroke.getKeyStroke(90, 2), jMenu, MenuEnableCondition.IF_UNDO_POSSIBLE);
        AbstractAction abstractAction2 = new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                History.redo();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(90, 3), jMenu, MenuEnableCondition.IF_REDO_POSSIBLE);
        MenuFactory.createMenuItem(new Fade(), KeyStroke.getKeyStroke(70, 3), jMenu, MenuEnableCondition.IF_FADING_POSSIBLE);
        MenuFactory.createMenuItem(SelectionActions.getCropAction(), null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        jMenu.addSeparator();
        MenuFactory.createMenuItem(new CopyAction(CopyType.COPY_LAYER), KeyStroke.getKeyStroke(67, 2), jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(new CopyAction(CopyType.COPY_COMPOSITE), KeyStroke.getKeyStroke(67, 3), jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(new PasteAction(false), KeyStroke.getKeyStroke(86, 2), jMenu, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(new PasteAction(true), KeyStroke.getKeyStroke(86, 3), jMenu);
        jMenu.addSeparator();
        AbstractAction abstractAction3 = new AbstractAction("Resize..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppLogic.resizeActiveImage();
            }
        };
        MenuFactory.createMenuItem(abstractAction3, KeyStroke.getKeyStroke(73, 10), jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        JMenu jMenu2 = new JMenu("Rotate/Flip");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new Rotate(90, "Rotate 90\u00b0 CW"), null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(new Rotate(180, "Rotate 180\u00b0"), null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(new Rotate(270, "Rotate 90\u00b0 CCW"), null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(new TransformLayer(), null, jMenu, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(Flip.createFlipOp(Flip.Direction.HORIZONTAL), null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        MenuFactory.createMenuItem(Flip.createFlipOp(Flip.Direction.VERTICAL), null, jMenu2, MenuEnableCondition.IF_THERE_IS_OPEN_IMAGE);
        jMenu.addSeparator();
        AbstractAction abstractAction4 = new AbstractAction("Preferences..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppPreferences.Panel.showInDialog();
            }
        };
        jMenu.add(abstractAction4);
        this.add(jMenu);
    }

    private void initColorsMenu() {
        JMenu jMenu = MenuBar.createMenu("Colors", 'C');
        MenuFactory.createMenuItem(new ColorBalance(), KeyStroke.getKeyStroke(66, 2), jMenu);
        MenuFactory.createMenuItem(new HueSat(), KeyStroke.getKeyStroke(85, 2), jMenu);
        MenuFactory.createMenuItem(new Colorize(), null, jMenu);
        MenuFactory.createMenuItem(new Levels(), KeyStroke.getKeyStroke(76, 2), jMenu);
        MenuFactory.createMenuItem(new Brightness(), null, jMenu);
        MenuFactory.createMenuItem(new GradientMap(), null, jMenu);
        MenuFactory.createMenuItem(new Solarize(), null, jMenu);
        MenuFactory.createMenuItem(new Invert(), KeyStroke.getKeyStroke(73, 2), jMenu);
        MenuFactory.createMenuItem(new ChannelInvert(), null, jMenu);
        MenuFactory.createMenuItem(new ChannelMixer(), null, jMenu);
        MenuBar.initExtractChannelsSubmenu(jMenu);
        MenuBar.initReduceColorsSubmenu(jMenu);
        MenuBar.initFillSubmenu(jMenu);
        this.add(jMenu);
    }

    private static void initFillSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Fill with");
        MenuFactory.createMenuItem(new Fill(FillType.FOREGROUND), KeyStroke.getKeyStroke(8, 8), jMenu2);
        MenuFactory.createMenuItem(new Fill(FillType.BACKGROUND), KeyStroke.getKeyStroke(8, 2), jMenu2);
        MenuFactory.createMenuItem(new Fill(FillType.TRANSPARENT), null, jMenu2);
        MenuFactory.createMenuItem(new FillWithColorWheel(), null, jMenu2);
        MenuFactory.createMenuItem(new JHFourColorGradient(), null, jMenu2);
        MenuFactory.createMenuItem(new Starburst(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initExtractChannelsSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Extract Channels");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new ExtractChannel(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new Luminosity(), null, jMenu2);
        MenuFactory.createMenuItem(NoDialogPixelOpFactory.getValueChannelOp(), null, jMenu2);
        MenuFactory.createMenuItem(NoDialogPixelOpFactory.getDesaturateChannelOp(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(NoDialogPixelOpFactory.getHueChannelOp(), null, jMenu2);
        MenuFactory.createMenuItem(NoDialogPixelOpFactory.getHueInColorsChannelOp(), null, jMenu2);
        MenuFactory.createMenuItem(NoDialogPixelOpFactory.getSaturationChannelOp(), null, jMenu2);
    }

    private static void initReduceColorsSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Reduce Colors");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new JHQuantize(), null, jMenu2);
        MenuFactory.createMenuItem(new Posterize(), null, jMenu2);
        MenuFactory.createMenuItem(new Threshold(), null, jMenu2);
    }

    private void initSelectMenu() {
        JMenu jMenu = MenuBar.createMenu("Selection", 'S');
        MenuFactory.createMenuItem(SelectionActions.getDeselectAction(), KeyStroke.getKeyStroke(68, 2), jMenu, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(SelectionActions.getInvertSelectionAction(), KeyStroke.getKeyStroke(73, 3), jMenu, MenuEnableCondition.ACTION_MANAGED);
        jMenu.addSeparator();
        MenuFactory.createMenuItem(SelectionActions.getTraceWithBrush(), null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(SelectionActions.getTraceWithEraser(), null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        this.add(jMenu);
    }

    private void initFilterMenu() {
        JMenu jMenu = MenuBar.createMenu("Filter", 'T');
        MenuBar.initBlurSharpenSubmenu(jMenu);
        MenuBar.initDistortSubmenu(jMenu);
        MenuBar.initLightSubmenu(jMenu);
        MenuBar.initFunSubmenu(jMenu);
        MenuBar.initNoiseSubmenu(jMenu);
        MenuBar.initRenderSubmenu(jMenu);
        MenuBar.initArtisticSubmenu(jMenu);
        MenuBar.initFindEdgesSubmenu(jMenu);
        MenuBar.initOtherSubmenu(jMenu);
        MenuFactory.createMenuItem(TextFilter.INSTANCE, KeyStroke.getKeyStroke('T'), jMenu);
        this.add(jMenu);
    }

    private static void initRenderSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Render");
        MenuFactory.createMenuItem(new Clouds(), null, jMenu2);
        MenuFactory.createMenuItem(new ValueNoise(), null, jMenu2);
        MenuFactory.createMenuItem(new JHCaustics(), null, jMenu2);
        MenuFactory.createMenuItem(new JHPlasma(), null, jMenu2);
        MenuFactory.createMenuItem(new JHWood(), null, jMenu2);
        MenuFactory.createMenuItem(new JHCells(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initFindEdgesSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Find Edges");
        MenuFactory.createMenuItem(new JHConvolutionEdge(), null, jMenu2);
        MenuFactory.createMenuItem(new JHLaplacian(), null, jMenu2);
        MenuFactory.createMenuItem(new JHDifferenceOfGaussians(), null, jMenu2);
        MenuFactory.createMenuItem(new Canny(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initOtherSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Other");
        MenuFactory.createMenuItem(new Convolve(3), null, jMenu2);
        MenuFactory.createMenuItem(new Convolve(5), null, jMenu2);
        MenuFactory.createMenuItem(new JHOffset(), null, jMenu2);
        MenuFactory.createMenuItem(new Mirror(), null, jMenu2);
        MenuFactory.createMenuItem(new JHDropShadow(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initArtisticSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Artistic");
        MenuFactory.createMenuItem(new JHStamp(), null, jMenu2);
        MenuFactory.createMenuItem(new JHDryBrush(), null, jMenu2);
        MenuFactory.createMenuItem(new Orton(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initBlurSharpenSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Blur/Sharpen");
        MenuFactory.createMenuItem(new JHGaussianBlur(), null, jMenu2);
        MenuFactory.createMenuItem(new JHSmartBlur(), null, jMenu2);
        MenuFactory.createMenuItem(new JHBoxBlur(), null, jMenu2);
        MenuFactory.createMenuItem(new FastBlur(), null, jMenu2);
        MenuFactory.createMenuItem(new JHLensBlur(), null, jMenu2);
        MenuFactory.createMenuItem(new JHMotionBlur(JHMotionBlur.Mode.MOTION_BLUR), null, jMenu2);
        MenuFactory.createMenuItem(new JHMotionBlur(JHMotionBlur.Mode.SPIN_ZOOM_BLUR), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new JHUnsharpMask(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initNoiseSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Noise");
        MenuFactory.createMenuItem(new JHReduceNoise(), null, jMenu2);
        MenuFactory.createMenuItem(new JHMedian(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new AddNoise(), null, jMenu2);
        MenuFactory.createMenuItem(new JHPixelate(), null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initLightSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Light");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new JHGlow(), null, jMenu2);
        MenuFactory.createMenuItem(new JHSparkle(), null, jMenu2);
        MenuFactory.createMenuItem(new JHRays(), null, jMenu2);
        MenuFactory.createMenuItem(new JHGlint(), null, jMenu2);
    }

    private static void initDistortSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Distort");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new JHPinch(), null, jMenu2);
        MenuFactory.createMenuItem(new JHFishEye(), null, jMenu2);
        MenuFactory.createMenuItem(new CircleToSquare(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new JHTurbulentDistortion(), null, jMenu2);
        MenuFactory.createMenuItem(new JHWaterRipple(), null, jMenu2);
        MenuFactory.createMenuItem(new JHWaves(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new GlassTile(), null, jMenu2);
        MenuFactory.createMenuItem(new JHFrostedGlass(), null, jMenu2);
        jMenu2.addSeparator();
        MenuFactory.createMenuItem(new JHPolarCoordinates(), null, jMenu2);
        MenuFactory.createMenuItem(new JHWrapAroundArc(), null, jMenu2);
    }

    private static void initFunSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Fun");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new JHKaleidoscope(), null, jMenu2);
        MenuFactory.createMenuItem(new Collage(), null, jMenu2);
        MenuFactory.createMenuItem(new JHCrystallize(), null, jMenu2);
        MenuFactory.createMenuItem(new JHPointillize(), null, jMenu2);
        MenuFactory.createMenuItem(new JHVideoFeedback(), null, jMenu2);
        MenuFactory.createMenuItem(new RandomSpheres(), null, jMenu2);
        MenuFactory.createMenuItem(new JHSmear(), null, jMenu2);
        MenuFactory.createMenuItem(new JHEmboss(), null, jMenu2);
    }

    private void initLayerMenu() {
        JMenu jMenu = MenuBar.createMenu("Layer", 'L');
        jMenu.add(AddNewLayerAction.INSTANCE);
        jMenu.add(DeleteActiveLayerAction.INSTANCE);
        AbstractAction abstractAction = new AbstractAction("Flatten Image"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.flattenImage();
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu);
        AbstractAction abstractAction2 = new AbstractAction("Merge Down"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.mergeDown();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(69, 2), jMenu);
        AbstractAction abstractAction3 = new AbstractAction("Duplicate Layer"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.duplicateLayer();
            }
        };
        MenuFactory.createMenuItem(abstractAction3, KeyStroke.getKeyStroke(74, 2), jMenu);
        AbstractAction abstractAction4 = new AbstractAction("New Layer from Composite"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.addNewLayerFromComposite("Composite");
            }
        };
        MenuFactory.createMenuItem(abstractAction4, KeyStroke.getKeyStroke(69, 11), jMenu);
        AbstractAction abstractAction5 = new AbstractAction("Layer to Canvas Size"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.layerToCanvasSize();
            }
        };
        MenuFactory.createMenuItem(abstractAction5, null, jMenu);
        MenuBar.initLayerStackSubmenu(jMenu);
        this.add(jMenu);
    }

    private static void initLayerStackSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Layer Stack");
        MenuFactory.createMenuItem(LayerUpAction.INSTANCE, KeyStroke.getKeyStroke(93, 2), jMenu2);
        MenuFactory.createMenuItem(LayerDownAction.INSTANCE, KeyStroke.getKeyStroke(91, 2), jMenu2);
        AbstractAction abstractAction = new AbstractAction("Layer to Top"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.moveActiveLayerToTop();
            }
        };
        MenuFactory.createMenuItem(abstractAction, KeyStroke.getKeyStroke(93, 3), jMenu2);
        AbstractAction abstractAction2 = new AbstractAction("Layer to Bottom"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.moveActiveLayerToBottom();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(91, 3), jMenu2);
        jMenu2.addSeparator();
        AbstractAction abstractAction3 = new AbstractAction("Raise Layer Selection"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.moveLayerSelectionUp();
            }
        };
        MenuFactory.createMenuItem(abstractAction3, KeyStroke.getKeyStroke(93, 8), jMenu2);
        AbstractAction abstractAction4 = new AbstractAction("Lower Layer Selection"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                composition.moveLayerSelectionDown();
            }
        };
        MenuFactory.createMenuItem(abstractAction4, KeyStroke.getKeyStroke(91, 8), jMenu2);
        jMenu.add(jMenu2);
    }

    private void initViewMenu() {
        JMenu jMenu = MenuBar.createMenu("View", 'V');
        jMenu.add(ZoomMenu.INSTANCE);
        jMenu.addSeparator();
        jMenu.add(new ShowHideStatusBarAction());
        MenuFactory.createMenuItem(new ShowHideHistogramsAction(), KeyStroke.getKeyStroke(117, 0), jMenu, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(new ShowHideLayersAction(), KeyStroke.getKeyStroke(118, 0), jMenu, MenuEnableCondition.ACTION_MANAGED);
        jMenu.add(new ShowHideToolsAction());
        MenuFactory.createMenuItem(ShowHideAllAction.INSTANCE, KeyStroke.getKeyStroke(9, 0), jMenu, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction = new AbstractAction("Set Default Workspace"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppPreferences.WorkSpace.setDefault();
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        jMenu.addSeparator();
        MenuBar.initArrangeWindowsSubmenu(jMenu);
        this.add(jMenu);
    }

    private static void initArrangeWindowsSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Arrange Windows");
        AbstractAction abstractAction = new AbstractAction("Cascade"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PixelitorWindow.getInstance().cascadeWindows();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu2);
        AbstractAction abstractAction2 = new AbstractAction("Tile"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PixelitorWindow.getInstance().tileWindows();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu2);
        jMenu.add(jMenu2);
    }

    private void initDevelopMenu() {
        JMenu jMenu = MenuBar.createMenu("Develop", 'D');
        MenuBar.initDebugSubmenu(jMenu);
        MenuBar.initTestSubmenu(jMenu);
        MenuBar.initExperimentalSubmenu(jMenu);
        AbstractAction abstractAction = new AbstractAction("New Text Layer..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(PixelitorWindow.getInstance(), "Text:", "Text Layer Text", 3);
                Composition composition = AppLogic.getActiveComp();
                TextLayer textLayer = new TextLayer(composition, "text layer", string);
                composition.addLayer((Layer)textLayer, true, true, false);
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu);
        AbstractAction abstractAction2 = new AbstractAction("New Global Adjustment Layer..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                AdjustmentLayer adjustmentLayer = new AdjustmentLayer(composition, "invert adjustment", new Invert());
                composition.addLayer((Layer)adjustmentLayer, true, true, false);
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu);
        AbstractAction abstractAction3 = new AbstractAction("Filter Creator..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterCreator.showInDialog(PixelitorWindow.getInstance());
            }
        };
        MenuFactory.createMenuItem(abstractAction3, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction4 = new AbstractAction("Debug Special"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BufferedImage bufferedImage = AppLogic.getActiveCompositeImage();
                MultiplyComposite multiplyComposite = new MultiplyComposite(1.0f);
                long l = System.nanoTime();
                int n = 100;
                for (int i = 0; i < n; ++i) {
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setComposite(multiplyComposite);
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.dispose();
                }
                long l2 = (System.nanoTime() - l) / 1000000L;
                System.out.println("MenuBar.actionPerformed: it took " + l2 + " ms, average time = " + l2 / (long)n);
            }
        };
        MenuFactory.createMenuItem(abstractAction4, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction5 = new AbstractAction("Add Layer Mask"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Layer layer = AppLogic.getActiveComp().getActiveLayer();
                layer.addTestLayerMask();
            }
        };
        MenuFactory.createMenuItem(abstractAction5, null, jMenu);
        AbstractAction abstractAction6 = new AbstractAction("Dump Event Queue"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugEventQueue.dump();
            }
        };
        MenuFactory.createMenuItem(abstractAction6, null, jMenu);
        this.initLayerMaskSubmenu(jMenu);
        this.add(jMenu);
    }

    private void initLayerMaskSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Layer Mask");
        AbstractAction abstractAction = new AbstractAction("Edit Layer Mask"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageComponent imageComponent = AppLogic.getActiveImageComponent();
                if (imageComponent.getComp().getActiveLayer().hasLayerMask()) {
                    imageComponent.setLayerMaskEditing(true);
                } else {
                    ExceptionHandler.showInfoDialog("No Layer mask", "The active layer has no layer mask");
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu2);
        AbstractAction abstractAction2 = new AbstractAction("Edit Composition"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageComponent imageComponent = AppLogic.getActiveImageComponent();
                if (imageComponent != null) {
                    imageComponent.setLayerMaskEditing(false);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu2);
        jMenu.add(jMenu2);
    }

    private static void initExperimentalSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Experimental");
        jMenu.add(jMenu2);
        MenuFactory.createMenuItem(new Magnify(), null, jMenu2);
        MenuFactory.createMenuItem(EnlargeCanvas.getAction(), null, jMenu2);
        MenuFactory.createMenuItem(new DrawGrid(), null, jMenu2);
        MenuFactory.createMenuItem(new Brick(), null, jMenu2);
    }

    private static void initTestSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Test");
        MenuFactory.createMenuItem(new ParamTest(), KeyStroke.getKeyStroke(80, 2), jMenu2);
        AbstractAction abstractAction = new AbstractAction("Random Resize"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OpTests.randomResize();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction, KeyStroke.getKeyStroke(77, 2), jMenu2);
        AbstractAction abstractAction2 = new AbstractAction("1001 Tool Actions"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ToolTests.randomToolActions();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu2);
        AbstractAction abstractAction3 = new AbstractAction("Robot Test"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RobotTest.runRobot();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction3, KeyStroke.getKeyStroke(82, 2), jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction4 = new AbstractAction("Operation Performance Test..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new PerformanceTestingDialog(PixelitorWindow.getInstance());
            }
        };
        MenuFactory.createMenuItem(abstractAction4, null, jMenu2);
        AbstractAction abstractAction5 = new AbstractAction("getCompositeImage() Performance Test..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpTests.getCompositeImagePerformanceTest();
            }
        };
        MenuFactory.createMenuItem(abstractAction5, null, jMenu2);
        jMenu2.addSeparator();
        AbstractAction abstractAction6 = new AbstractAction("Run All Operations on Current Layer"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpTests.runAllOpsOnCurrentLayer();
            }
        };
        MenuFactory.createMenuItem(abstractAction6, null, jMenu2);
        AbstractAction abstractAction7 = new AbstractAction("Save the Result of Each Operation..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpTests.saveTheResultOfEachOp();
            }
        };
        MenuFactory.createMenuItem(abstractAction7, null, jMenu2);
        AbstractAction abstractAction8 = new AbstractAction("Save Current Image in All Formats..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.saveCurrentImageInAllFormats();
            }
        };
        MenuFactory.createMenuItem(abstractAction8, null, jMenu2);
        jMenu2.addSeparator();
        AbstractAction abstractAction9 = new AbstractAction("Create Splash Image"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageTests.createSplashImage();
            }
        };
        MenuFactory.createMenuItem(abstractAction9, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction10 = new AbstractAction("Save Many Splash Images..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageTests.saveManySplashImages();
            }
        };
        MenuFactory.createMenuItem(abstractAction10, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        jMenu2.addSeparator();
        AbstractAction abstractAction11 = new AbstractAction("Test Layer Operations"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageTests.testLayers();
            }
        };
        MenuFactory.createMenuItem(abstractAction11, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction12 = new AbstractAction("Test Tools"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolTests.testTools();
            }
        };
        MenuFactory.createMenuItem(abstractAction12, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction13 = new AbstractAction("IO Overlay Blur..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageTests.ioOverlayBlur();
            }
        };
        MenuFactory.createMenuItem(abstractAction13, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        jMenu.add(jMenu2);
    }

    private static void initDebugSubmenu(JMenu jMenu) {
        JMenu jMenu2 = new JMenu("Debug");
        AbstractAction abstractAction = new AbstractAction("Debug App..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppLogic.showDebugAppDialog();
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction2 = new AbstractAction("Debug History..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                History.showHistory();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(116, 0), jMenu2);
        AbstractAction abstractAction3 = new AbstractAction("Image Info..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                int n = composition.getCanvasWidth();
                int n2 = composition.getCanvasHeight();
                long l = n * n2 * 4;
                float f = (float)l / 1048576.0f;
                String string = String.format("Canvas Width = %d pixels\nCanvas Height = %d pixels\nSize in Memory = %.2f Mbytes/layer", n, n2, Float.valueOf(f));
                ExceptionHandler.showInfoDialog("Image Info - " + composition.getName(), string);
            }
        };
        MenuFactory.createMenuItem(abstractAction3, null, jMenu2);
        AbstractAction abstractAction4 = new AbstractAction("repaint() on the active image"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppLogic.getActiveImageComponent().repaint();
            }
        };
        MenuFactory.createMenuItem(abstractAction4, null, jMenu2);
        AbstractAction abstractAction5 = new AbstractAction("imageChanged(true, true) on the active image"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppLogic.getActiveComp().imageChanged(true, true);
            }
        };
        MenuFactory.createMenuItem(abstractAction5, null, jMenu2);
        AbstractAction abstractAction6 = new AbstractAction("revalidate() the main window"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JComponent)PixelitorWindow.getInstance().getContentPane()).revalidate();
            }
        };
        MenuFactory.createMenuItem(abstractAction6, null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        AbstractAction abstractAction7 = new AbstractAction("reset the translation of current layer"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                Layer layer = composition.getActiveLayer();
                if (layer instanceof ContentLayer) {
                    ContentLayer contentLayer = (ContentLayer)layer;
                    contentLayer.setTranslationX(0);
                    contentLayer.setTranslationY(0);
                    composition.imageChanged(true, true);
                }
            }
        };
        MenuFactory.createMenuItem(abstractAction7, null, jMenu2);
        AbstractAction abstractAction8 = new AbstractAction("Update Histograms"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Composition composition = AppLogic.getActiveComp();
                HistogramsPanel.INSTANCE.updateFromCompIfShown(composition);
            }
        };
        MenuFactory.createMenuItem(abstractAction8, null, jMenu2);
        AbstractAction abstractAction9 = new AbstractAction("Save All Images to Directory..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenSaveManager.saveAllImagesToDir();
            }
        };
        MenuFactory.createMenuItem(abstractAction9, null, jMenu2);
        jMenu.add(jMenu2);
    }

    private void initHelpMenu() {
        JMenu jMenu = MenuBar.createMenu("Help", 'H');
        AbstractAction abstractAction = new AbstractAction("Tip of the Day"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TipsOfTheDay.showTips(PixelitorWindow.getInstance(), true);
            }
        };
        MenuFactory.createMenuItem(abstractAction, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        JMenu jMenu2 = new JMenu("Web");
        MenuFactory.createMenuItem(new OpenInBrowserAction("Ask for Help", "https://sourceforge.net/projects/pixelitor/forums/forum/1034234"), null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(new OpenInBrowserAction("Discuss Pixelitor", "https://sourceforge.net/projects/pixelitor/forums/forum/1034233"), null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        MenuFactory.createMenuItem(new OpenInBrowserAction("Report a Bug", "https://sourceforge.net/tracker/?group_id=285935&atid=1211793"), null, jMenu2, MenuEnableCondition.ACTION_MANAGED);
        jMenu.add(jMenu2);
        AbstractAction abstractAction2 = new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.showDialog();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, null, jMenu, MenuEnableCondition.ACTION_MANAGED);
        this.add(jMenu);
    }

    private static JMenu createMenu(String string, char c) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(c);
        return jMenu;
    }
}

