/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import javax.swing.AbstractAction;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.utils.ImageUtils;

public class PasteAction
extends AbstractAction {
    private static int pastedCount = 1;
    private boolean pasteAsNewLayer = false;

    public PasteAction(boolean bl) {
        super(bl ? "Paste as New Layer" : "Paste as New Image");
        this.pasteAsNewLayer = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            try {
                Object object;
                BufferedImage bufferedImage = PasteAction.getImageFromClipboard();
                if (bufferedImage == null) break block8;
                int n = bufferedImage.getType();
                if (n != 3) {
                    bufferedImage = ImageUtils.convertToARGB_PRE(bufferedImage, true);
                } else {
                    object = bufferedImage.getRaster();
                    int n2 = ((Raster)object).getMinX();
                    int n3 = ((Raster)object).getMinY();
                    try {
                        bufferedImage = ImageUtils.copyImage(bufferedImage);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("PasteAction.actionPerformed minX = " + n2 + ", minY = " + n3);
                        throw illegalArgumentException;
                    }
                }
                if (this.pasteAsNewLayer) {
                    object = AppLogic.getActiveComp();
                    ImageLayer imageLayer = new ImageLayer((Composition)object, bufferedImage, "Pasted Layer", ((Composition)object).getCanvasWidth(), ((Composition)object).getCanvasHeight());
                    ((Composition)object).addLayer((Layer)imageLayer, true, true, false);
                } else {
                    object = "Pasted Image " + pastedCount;
                    PixelitorWindow.getInstance().addNewImage(bufferedImage, null, (String)object);
                    ++pastedCount;
                }
            }
            catch (Exception exception) {
                ExceptionHandler.showExceptionDialog(exception);
            }
        }
    }

    private static BufferedImage getImageFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable == null) {
            ExceptionHandler.showInfoDialog("Paste", "There is nothing to paste.");
            return null;
        }
        BufferedImage bufferedImage = null;
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                bufferedImage = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ExceptionHandler.showExceptionDialog(unsupportedFlavorException);
            }
            catch (IOException iOException) {
                ExceptionHandler.showExceptionDialog(iOException);
            }
        } else {
            ExceptionHandler.showInfoDialog("Paste", "The clipboard content is not an image.");
            return null;
        }
        return bufferedImage;
    }
}

