/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pixelitor.ExceptionHandler;
import pixelitor.io.OpenSaveManager;
import pixelitor.menus.RecentFileInfo;
import pixelitor.menus.RecentFilesMenuItem;
import pixelitor.utils.AppPreferences;

public final class RecentFilesMenu
extends JMenu {
    private static final int DEFAULT_MAX_RECENT_FILES = 10;
    private static RecentFilesMenu singleInstance;
    private final int maxRecentFiles;
    private JMenuItem clearMenuItem;
    private List<RecentFileInfo> recentFileNames;
    private final ActionListener fileOpener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                RecentFilesMenuItem recentFilesMenuItem = (RecentFilesMenuItem)actionEvent.getSource();
                File file = recentFilesMenuItem.getFileInfo().getFile();
                if (file.exists()) {
                    OpenSaveManager.openFile(file);
                } else {
                    JOptionPane.showMessageDialog(null, "The file " + file + " does not exist.", "Problem", 0);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.showExceptionDialog(exception);
            }
        }
    };

    private RecentFilesMenu() {
        super("Recent Files");
        this.maxRecentFiles = 10;
        this.clearMenuItem = new JMenuItem("Clear Recent Files");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RecentFilesMenu.this.clear();
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
            }
        };
        this.clearMenuItem.addActionListener(actionListener);
        this.load();
        this.rebuildGUI();
    }

    private void clear() {
        AppPreferences.removeRecentFiles(this.maxRecentFiles);
        this.recentFileNames.clear();
        this.clearGUI();
    }

    public static synchronized RecentFilesMenu getInstance() {
        if (singleInstance == null) {
            singleInstance = new RecentFilesMenu();
        }
        return singleInstance;
    }

    public void addFile(File file) {
        if (file.exists()) {
            RecentFileInfo recentFileInfo = new RecentFileInfo(file);
            if (this.recentFileNames.contains(recentFileInfo)) {
                this.recentFileNames.remove(recentFileInfo);
            }
            this.recentFileNames.add(0, recentFileInfo);
            if (this.recentFileNames.size() > this.maxRecentFiles) {
                this.recentFileNames.remove(this.maxRecentFiles);
            }
            this.rebuildGUI();
        }
    }

    private void load() {
        this.recentFileNames = AppPreferences.loadRecentFiles(this.maxRecentFiles);
    }

    private void clearGUI() {
        this.removeAll();
    }

    public List<RecentFileInfo> getRecentFileNamesForSaving() {
        if (this.recentFileNames.size() > this.maxRecentFiles) {
            return this.recentFileNames.subList(0, this.maxRecentFiles);
        }
        return this.recentFileNames;
    }

    private void rebuildGUI() {
        this.clearGUI();
        int n = this.recentFileNames.size();
        for (int i = 0; i < n; ++i) {
            RecentFileInfo recentFileInfo = this.recentFileNames.get(i);
            recentFileInfo.setNr(i + 1);
            RecentFilesMenuItem recentFilesMenuItem = new RecentFilesMenuItem(recentFileInfo);
            this.add(recentFilesMenuItem);
            recentFilesMenuItem.addActionListener(this.fileOpener);
        }
        if (!this.recentFileNames.isEmpty()) {
            this.addSeparator();
            this.add(this.clearMenuItem);
        }
    }
}

