/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.OKCancelDialog;

public class ScreenCaptureAction
extends AbstractAction {
    private JCheckBox hidePixelitorCB;
    private static int captureCount = 1;

    public ScreenCaptureAction() {
        super("Screen Capture...");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OKCancelDialog oKCancelDialog = new OKCancelDialog(this.getSettingsPanel(), "Screen Capture"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                ScreenCaptureAction.this.capture();
                this.dispose();
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }

    public JPanel getSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)jPanel, "Hide Pixelitor", 0, 0);
        this.hidePixelitorCB = new JCheckBox();
        this.hidePixelitorCB.setSelected(true);
        GridBagHelper.addControl(jPanel, this.hidePixelitorCB);
        return jPanel;
    }

    private void capture() {
        try {
            int n;
            Robot robot = new Robot();
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            boolean bl = this.hidePixelitorCB.isSelected();
            if (bl) {
                pixelitorWindow.iconify();
                Thread.sleep(500L);
            }
            BufferedImage bufferedImage = robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
            if (bl) {
                pixelitorWindow.deiconify();
            }
            if ((n = bufferedImage.getType()) != 3) {
                bufferedImage = ImageUtils.convertToARGB_PRE(bufferedImage, true);
            }
            String string = "Screen Capture " + captureCount;
            pixelitorWindow.addNewImage(bufferedImage, null, string);
            ++captureCount;
        }
        catch (Exception exception) {
            ExceptionHandler.showExceptionDialog(exception);
        }
    }
}

