/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.Shape;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.layers.Layers;
import pixelitor.selection.Selection;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.tools.Tools;

public final class SelectionActions {
    private static AbstractAction cropAction = new AbstractAction("Crop"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AppLogic.cropActiveImage();
        }
    };
    private static AbstractAction deselectAction = new AbstractAction("Deselect"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AppLogic.getActiveComp().deselect(true);
        }
    };
    private static AbstractAction invertSelectionAction = new AbstractAction("Invert Selection"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AppLogic.getActiveComp().invertSelection();
        }
    };
    private static AbstractAction traceWithBrush = new TraceAction("Stroke with Current Brush", Tools.BRUSH);
    private static AbstractAction traceWithEraser = new TraceAction("Stroke with Current Eraser", Tools.ERASER);

    private SelectionActions() {
    }

    public static void setEnabled(boolean bl) {
        boolean bl2;
        Composition composition;
        if (Build.CURRENT.isRobotTest() && (composition = AppLogic.getActiveComp()) != null && (bl2 = composition.hasSelection()) != bl) {
            throw new IllegalStateException("hasSelection = " + bl2 + ", b = " + bl);
        }
        cropAction.setEnabled(bl);
        traceWithBrush.setEnabled(bl);
        traceWithEraser.setEnabled(bl);
        deselectAction.setEnabled(bl);
        invertSelectionAction.setEnabled(bl);
    }

    public static boolean areEnabled() {
        return cropAction.isEnabled();
    }

    public static AbstractAction getCropAction() {
        return cropAction;
    }

    public static AbstractAction getTraceWithBrush() {
        return traceWithBrush;
    }

    public static AbstractAction getTraceWithEraser() {
        return traceWithEraser;
    }

    public static AbstractAction getDeselectAction() {
        return deselectAction;
    }

    public static AbstractAction getInvertSelectionAction() {
        return invertSelectionAction;
    }

    static {
        SelectionActions.setEnabled(false);
    }

    private static class TraceAction
    extends AbstractAction {
        private AbstractBrushTool brushTool;

        private TraceAction(String string, AbstractBrushTool abstractBrushTool) {
            super(string);
            this.brushTool = abstractBrushTool;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Shape shape;
            if (!Layers.activeIsImageLayer()) {
                ExceptionHandler.showNotImageLayerDialog();
                return;
            }
            Composition composition = AppLogic.getActiveComp();
            Selection selection = composition.getSelection();
            if (selection != null && (shape = selection.getShape()) != null) {
                this.brushTool.trace(composition, shape);
            }
        }
    }
}

