/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.selection;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import javax.swing.Timer;
import pixelitor.Build;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.ImageComponent;
import pixelitor.selection.SelectionInteraction;
import pixelitor.selection.SelectionType;
import pixelitor.tools.UserDrag;

public class Selection {
    private float dashPhase;
    private ImageComponent ic;
    private Timer timer;
    private Shape currentSelectionShape;
    private Shape lastSelectionShape;
    private SelectionType selectionType;
    private SelectionInteraction selectionInteraction;
    private static final float[] MARCHING_ANTS_DASH = new float[]{4.0f, 4.0f};
    private State state;

    public Selection(ImageComponent imageComponent, SelectionType selectionType, SelectionInteraction selectionInteraction) {
        this.ic = imageComponent;
        this.selectionType = selectionType;
        this.selectionInteraction = selectionInteraction;
        this.state = State.NO_SHAPE_YET;
    }

    public Selection(Shape shape, ImageComponent imageComponent) {
        this.currentSelectionShape = shape;
        this.ic = imageComponent;
        this.startMarching();
        this.state = State.HAS_SHAPE;
    }

    public final void updateSelection(UserDrag userDrag) {
        this.currentSelectionShape = this.selectionType.updateShape(userDrag, this.currentSelectionShape);
        if (this.state == State.NO_SHAPE_YET) {
            this.startMarching();
            this.state = State.HAS_SHAPE;
        }
    }

    public void startNewShape(SelectionType selectionType, SelectionInteraction selectionInteraction) {
        if (this.state != State.HAS_SHAPE) {
            throw new IllegalStateException("state = " + (Object)((Object)this.state));
        }
        this.selectionType = selectionType;
        this.selectionInteraction = selectionInteraction;
        if (selectionInteraction != SelectionInteraction.REPLACE) {
            this.lastSelectionShape = this.currentSelectionShape;
        }
    }

    public boolean combineShapes() {
        boolean bl = true;
        if (this.lastSelectionShape != null) {
            this.currentSelectionShape = this.selectionInteraction.combine(this.lastSelectionShape, this.currentSelectionShape);
            Rectangle rectangle = this.currentSelectionShape.getBounds();
            if (rectangle.isEmpty()) {
                this.currentSelectionShape = null;
                this.updateComponent();
                if (!Build.CURRENT.isRobotTest()) {
                    ExceptionHandler.showInfoDialog("Nothing selected", "As a result of the " + this.selectionInteraction.toString().toLowerCase() + " operation, nothing is selected now.");
                }
                bl = false;
            }
            this.lastSelectionShape = null;
        } else if (this.currentSelectionShape.getBounds().isEmpty()) {
            bl = false;
        }
        return bl;
    }

    private void startMarching() {
        this.timer = new Timer(100, null);
        this.timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Selection.this.dashPhase = (float)((double)Selection.this.dashPhase + 1.0 / Selection.this.ic.getViewScale());
                Selection.this.updateComponent();
            }
        });
        this.timer.start();
    }

    public void paintMarchingAnts(Graphics2D graphics2D) {
        if (this.currentSelectionShape == null) {
            return;
        }
        this.paintAnts(graphics2D, this.lastSelectionShape, 0.0f);
        this.paintAnts(graphics2D, this.currentSelectionShape, this.dashPhase);
    }

    private void paintAnts(Graphics2D graphics2D, Shape shape, float f) {
        float[] fArray;
        if (shape == null) {
            return;
        }
        double d = this.ic.getViewScale();
        float f2 = (float)(1.0 / d);
        graphics2D.setPaint(Color.WHITE);
        if (d == 1.0) {
            fArray = MARCHING_ANTS_DASH;
        } else {
            float f3 = (float)(4.0 / d);
            fArray = new float[]{f3, f3};
        }
        BasicStroke basicStroke = new BasicStroke(f2, 0, 1, 0.0f, fArray, f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(shape);
        graphics2D.setPaint(Color.BLACK);
        BasicStroke basicStroke2 = new BasicStroke(f2, 0, 1, 0.0f, fArray, (float)((double)f + 4.0 / d));
        graphics2D.setStroke(basicStroke2);
        graphics2D.draw(shape);
    }

    public void invert(Rectangle rectangle) {
        if (this.currentSelectionShape != null) {
            Area area = new Area(this.currentSelectionShape);
            Area area2 = new Area(rectangle);
            area2.subtract(area);
            this.currentSelectionShape = area2;
        }
    }

    public void deselectAndDispose() {
        switch (this.state) {
            case NO_SHAPE_YET: {
                this.state = State.DIED;
                break;
            }
            case HAS_SHAPE: {
                this.timer.stop();
                this.updateComponent();
                this.ic = null;
                this.state = State.DIED;
                break;
            }
            case DIED: {
                throw new IllegalStateException("died twice");
            }
        }
    }

    private void updateComponent() {
        this.ic.repaint();
    }

    public void setShape(Shape shape) {
        this.currentSelectionShape = shape;
    }

    public SelectionInteraction getSelectionInteraction() {
        return this.selectionInteraction;
    }

    public boolean clipToCompSize(Composition composition) {
        if (this.currentSelectionShape != null) {
            Area area = new Area(new Rectangle(0, 0, composition.getCanvasWidth(), composition.getCanvasHeight()));
            Area area2 = new Area(this.currentSelectionShape);
            area2.intersect(area);
            this.currentSelectionShape = area2;
            this.updateComponent();
            return !this.currentSelectionShape.getBounds().isEmpty();
        }
        return false;
    }

    public Shape getTransformedShape(AffineTransform affineTransform) {
        Path2D.Float float_ = new Path2D.Float(this.getShape());
        float_.transform(affineTransform);
        return float_;
    }

    public void addNewPolygonalLassoPoint(UserDrag userDrag) {
        Polygon polygon = (Polygon)this.currentSelectionShape;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        int n = polygon.npoints;
        int n2 = n + 1;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[i];
            nArray4[i] = nArray2[i];
        }
        nArray3[n2 - 1] = userDrag.getEndX();
        nArray4[n2 - 1] = userDrag.getEndY();
        this.currentSelectionShape = new Polygon(nArray3, nArray4, n2);
    }

    public Shape getShape() {
        return this.state.getShape(this.currentSelectionShape);
    }

    public Rectangle getShapeBounds() {
        return this.state.getShapeBounds(this.currentSelectionShape);
    }

    public String toString() {
        return "Selection{composition=" + this.ic.getComp().getName() + ", currentSelectionShape-class=" + (this.currentSelectionShape == null ? "null" : this.currentSelectionShape.getClass().getName()) + ", currentSelectionShapeBounds=" + (this.currentSelectionShape == null ? "null" : this.currentSelectionShape.getBounds()) + ", lastSelectionShape-class=" + (this.lastSelectionShape == null ? "null" : this.lastSelectionShape.getClass().getName()) + ", selectionType=" + (Object)((Object)this.selectionType) + ", selectionInteraction=" + (Object)((Object)this.selectionInteraction) + ", state=" + (Object)((Object)this.state) + '}';
    }

    static enum State {
        NO_SHAPE_YET{

            @Override
            Rectangle getShapeBounds(Shape shape) {
                throw new IllegalStateException();
            }

            @Override
            Shape getShape(Shape shape) {
                return shape;
            }
        }
        ,
        HAS_SHAPE{

            @Override
            Rectangle getShapeBounds(Shape shape) {
                return shape.getBounds();
            }

            @Override
            Shape getShape(Shape shape) {
                if (shape == null) {
                    throw new IllegalStateException("null shape, while in HAS_SHAPE");
                }
                return shape;
            }
        }
        ,
        DIED{

            @Override
            Rectangle getShapeBounds(Shape shape) {
                throw new IllegalStateException();
            }

            @Override
            Shape getShape(Shape shape) {
                throw new IllegalStateException("getShape() called, while in DIED");
            }
        };


        abstract Rectangle getShapeBounds(Shape var1);

        abstract Shape getShape(Shape var1);
    }
}

