/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.PixelitorWindow;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.ImageUtils;

public class FgBgColorSelector
extends JLayeredPane
implements ActionListener {
    private JButton fgButton = new JButton();
    private JButton bgButton = new JButton();
    private Color fgColor = Color.black;
    private Color bgColor = Color.white;
    private static final int BIG_BUTTON_SIZE = 32;
    private static final int SMALL_BUTTON_SIZE = 16;
    private static final int SMALL_BUTTON_VERTICAL_SPACE = 20;
    public static final FgBgColorSelector INSTANCE = new FgBgColorSelector();
    private Action randomizeColorsAction;
    private Action resetToDefaultAction;
    private Action switchColorsAction;
    private boolean layerMaskEditing = false;

    private FgBgColorSelector() {
        this.setLayout(null);
        this.initButton(this.fgButton, "Set Foreground Color", 32, 2);
        this.fgButton.addActionListener(this);
        this.initButton(this.bgButton, "Set Background Color", 32, 1);
        this.bgButton.addActionListener(this);
        JButton jButton = new JButton();
        this.initButton(jButton, "Reset Default Colors (D)", 16, 1);
        JButton jButton2 = new JButton();
        this.initButton(jButton2, "Swap Colors (X)", 16, 1);
        JButton jButton3 = new JButton();
        this.initButton(jButton3, "Randomize Colors (R)", 16, 1);
        jButton.setLocation(0, 0);
        jButton2.setLocation(16, 0);
        jButton3.setLocation(32, 0);
        this.fgButton.setLocation(0, 20);
        this.bgButton.setLocation(16, 36);
        int n = 48;
        int n2 = n + 20;
        Dimension dimension = new Dimension(n, n2);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setFgColor(AppPreferences.loadFgColor());
        this.setBgColor(AppPreferences.loadBgColor());
        this.resetToDefaultAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FgBgColorSelector.this.setFgColor(Color.black);
                FgBgColorSelector.this.setBgColor(Color.white);
            }
        };
        jButton.addActionListener(this.resetToDefaultAction);
        this.switchColorsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = FgBgColorSelector.this.fgColor;
                FgBgColorSelector.this.setFgColor(FgBgColorSelector.this.bgColor);
                FgBgColorSelector.this.setBgColor(color);
            }
        };
        jButton2.addActionListener(this.switchColorsAction);
        this.randomizeColorsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FgBgColorSelector.this.setFgColor(ImageUtils.getRandomColor(false));
                FgBgColorSelector.this.setBgColor(ImageUtils.getRandomColor(false));
            }
        };
        jButton3.addActionListener(this.randomizeColorsAction);
        this.setupKeyboardShortcuts();
    }

    private void initButton(JButton jButton, String string, int n, int n2) {
        jButton.setToolTipText(string);
        jButton.setSize(n, n);
        this.add((Component)jButton, (Object)n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.fgButton) {
            Color color2 = ColorPicker.showDialog(PixelitorWindow.getInstance(), "Set foreground color", this.fgColor, false);
            if (color2 != null) {
                this.setFgColor(color2);
            }
        } else if (actionEvent.getSource() == this.bgButton && (color = ColorPicker.showDialog(PixelitorWindow.getInstance(), "Set background color", this.bgColor, false)) != null) {
            this.setBgColor(color);
        }
    }

    private Color getBgColor() {
        return this.getUsedColor(this.bgColor);
    }

    public static Color colorToGray(Color color) {
        int n = color.getRGB();
        int n2 = n >>> 16 & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2 + n3 + n4 / 3;
        return new Color(0xFF000000 | n5 << 16 | n5 << 8 | n5);
    }

    private Color getFgColor() {
        return this.getUsedColor(this.fgColor);
    }

    private Color getUsedColor(Color color) {
        if (this.layerMaskEditing) {
            return FgBgColorSelector.colorToGray(color);
        }
        return color;
    }

    public static Color getFG() {
        return INSTANCE.getFgColor();
    }

    public static Color getBG() {
        return INSTANCE.getBgColor();
    }

    public static void setFG(Color color) {
        INSTANCE.setFgColor(color);
    }

    public static void setBG(Color color) {
        INSTANCE.setBgColor(color);
    }

    public static void setRandomColors() {
        FgBgColorSelector.INSTANCE.randomizeColorsAction.actionPerformed(null);
    }

    public void setFgColor(Color color) {
        Color color2 = this.fgColor;
        this.fgColor = color;
        Color color3 = this.getUsedColor(this.fgColor);
        this.fgButton.setBackground(color3);
        if (color2 != null) {
            this.firePropertyChange("FG", color2, this.fgColor);
        }
    }

    public void setBgColor(Color color) {
        Color color2 = this.bgColor;
        this.bgColor = color;
        Color color3 = this.getUsedColor(this.bgColor);
        this.bgButton.setBackground(color3);
        if (color2 != null) {
            this.firePropertyChange("BG", color2, this.bgColor);
        }
    }

    private void setupKeyboardShortcuts() {
        GlobalKeyboardWatch.addKeyboardShortCut('d', true, "reset", this.resetToDefaultAction);
        GlobalKeyboardWatch.addKeyboardShortCut('x', true, "switch", this.switchColorsAction);
        GlobalKeyboardWatch.addKeyboardShortCut('r', true, "randomize", this.randomizeColorsAction);
    }
}

