/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import pixelitor.Composition;
import pixelitor.FillType;
import pixelitor.ImageComponent;
import pixelitor.filters.gui.RangeParam;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolAffectedArea;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.SliderSpinner;

public class PaintBucketTool
extends Tool {
    private RangeParam toleranceParam = new RangeParam("Tolerance", 0, 255, 20);
    private JComboBox fillComboBox;

    public PaintBucketTool() {
        super('p', "Paint Bucket", "paint_bucket_tool_icon.gif", "click to fill with the selected color", Cursor.getPredefinedCursor(0), true, true, false);
    }

    @Override
    void initSettingsPanel() {
        this.toolSettingsPanel.add(new SliderSpinner(this.toleranceParam, false, SliderSpinner.TextPosition.WEST));
        this.toolSettingsPanel.add(new JLabel("Fill With:"));
        this.fillComboBox = new JComboBox<Object>(new Object[]{FillType.FOREGROUND, FillType.BACKGROUND, FillType.TRANSPARENT});
        this.toolSettingsPanel.add(this.fillComboBox);
    }

    private Color getFillColor() {
        FillType fillType = (FillType)((Object)this.fillComboBox.getSelectedItem());
        return fillType.getColor();
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        Color color;
        int n = this.userDrag.getEndX();
        int n2 = this.userDrag.getEndY();
        Composition composition = imageComponent.getComp();
        ImageLayer imageLayer = composition.getActiveImageLayer();
        int n3 = imageLayer.getTranslationX();
        int n4 = imageLayer.getTranslationY();
        n -= n3;
        n2 -= n4;
        AffineTransform affineTransform = null;
        if (n3 != 0 || n4 != 0) {
            affineTransform = AffineTransform.getTranslateInstance(-n3, -n4);
        }
        BufferedImage bufferedImage = imageLayer.getBufferedImage();
        BufferedImage bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        BufferedImage bufferedImage3 = ImageUtils.copyImage(bufferedImage);
        Rectangle rectangle = PaintBucketTool.scanlineFloodFill(bufferedImage3, n, n2, color = this.getFillColor(), this.toleranceParam.getValue());
        if (rectangle != null) {
            ToolAffectedArea toolAffectedArea = new ToolAffectedArea(composition, rectangle, true);
            this.saveSubImageForUndo(bufferedImage2, toolAffectedArea);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            composition.setSelectionClipping(graphics2D, affineTransform);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
            graphics2D.dispose();
            composition.imageChanged(true, true);
        }
        bufferedImage3.flush();
    }

    private static Rectangle scanlineFloodFill(BufferedImage bufferedImage, int n, int n2, Color color, int n3) {
        int n4;
        int n5 = n;
        int n6 = n;
        int n7 = n2;
        int n8 = n2;
        int n9 = bufferedImage.getHeight();
        int n10 = bufferedImage.getWidth();
        if (n < 0 || n >= n10 || n2 < 0 || n2 >= n9) {
            return null;
        }
        int n11 = bufferedImage.getRGB(n, n2);
        if (n11 == (n4 = color.getRGB())) {
            return null;
        }
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        ArrayDeque<Point> arrayDeque = new ArrayDeque<Point>();
        arrayDeque.push(new Point(n, n2));
        while (!arrayDeque.isEmpty()) {
            Point point;
            boolean bl;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            Point point2 = (Point)arrayDeque.pop();
            n = point2.x;
            n2 = point2.y;
            int n18 = n2 * n10;
            for (n17 = n - 1; n17 >= 0 && PaintBucketTool.similarColor(nArray[n17 + n18], n11, n3); --n17) {
            }
            ++n17;
            for (n16 = n + 1; n16 < bufferedImage.getWidth() && PaintBucketTool.similarColor(nArray[n16 + n18], n11, n3); ++n16) {
            }
            --n16;
            if (n17 < n5) {
                n5 = n17;
            }
            if (n16 > n6) {
                n6 = n16;
            }
            if (n2 > n8) {
                n8 = n2;
            } else if (n2 < n7) {
                n7 = n2;
            }
            for (n15 = n17; n15 <= n16; ++n15) {
                n14 = n15 + n18;
                nArray[n14] = n4;
                blArray[n14] = true;
            }
            if (n2 > 0) {
                n15 = 0;
                n14 = (n2 - 1) * n10;
                for (n13 = n17; n13 <= n16; ++n13) {
                    n12 = n13 + n14;
                    boolean bl2 = bl = !blArray[n12] && PaintBucketTool.similarColor(nArray[n12], n11, n3);
                    if (n15 == 0 && bl) {
                        point = new Point(n13, n2 - 1);
                        arrayDeque.push(point);
                        n15 = 1;
                        continue;
                    }
                    if (n15 == 0 || bl) continue;
                    n15 = 0;
                }
            }
            if (n2 >= n9 - 1) continue;
            n15 = 0;
            n14 = (n2 + 1) * n10;
            for (n13 = n17; n13 <= n16; ++n13) {
                n12 = n13 + n14;
                boolean bl3 = bl = !blArray[n12] && PaintBucketTool.similarColor(nArray[n12], n11, n3);
                if (n15 == 0 && bl) {
                    point = new Point(n13, n2 + 1);
                    arrayDeque.push(point);
                    n15 = 1;
                    continue;
                }
                if (n15 == 0 || bl) continue;
                n15 = 0;
            }
        }
        return new Rectangle(n5, n7, n6 - n5 + 1, n8 - n7 + 1);
    }

    private static boolean similarColor(int n, int n2, int n3) {
        if (n == n2) {
            return true;
        }
        int n4 = n >>> 16 & 0xFF;
        int n5 = n >>> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >>> 16 & 0xFF;
        int n8 = n2 >>> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        return n7 <= n4 + n3 && n7 >= n4 - n3 && n8 <= n5 + n3 && n8 >= n5 - n3 && n9 <= n6 + n3 && n9 >= n6 - n3;
    }
}

