/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import com.bric.awt.CalligraphyStroke;
import com.jhlabs.awt.CompositeStroke;
import com.jhlabs.awt.ShapeStroke;
import com.jhlabs.awt.WobbleStroke;
import com.jhlabs.awt.ZigzagStroke;
import java.awt.BasicStroke;
import java.awt.Stroke;
import pixelitor.tools.shapes.Kiwi;

public enum StrokeType {
    BASIC{

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            BasicStroke basicStroke = new BasicStroke(f, n, n2, 1.5f, fArray, 0.0f);
            return basicStroke;
        }

        public String toString() {
            return "Basic";
        }

        @Override
        public int getExtraWidth(int n) {
            return 0;
        }
    }
    ,
    WOBBLE{
        private float lastWidth = 0.0f;
        private WobbleStroke wobbleStroke;

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            if (this.wobbleStroke == null) {
                this.wobbleStroke = new WobbleStroke(0.5f, f, 10.0f);
                this.lastWidth = f;
                return this.wobbleStroke;
            }
            if (f == this.lastWidth) {
                return this.wobbleStroke;
            }
            this.wobbleStroke = new WobbleStroke(0.5f, f, 10.0f);
            this.lastWidth = f;
            return this.wobbleStroke;
        }

        @Override
        public Stroke getInnerStroke() {
            return null;
        }

        public String toString() {
            return "Wobble";
        }

        @Override
        public int getExtraWidth(int n) {
            return (int)((double)n * 1.5);
        }
    }
    ,
    ZIGZAG{
        private Stroke tmp;

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            this.tmp = BASIC.getStroke(f, n, n2, fArray);
            ZigzagStroke zigzagStroke = new ZigzagStroke(this.tmp, f, f);
            return zigzagStroke;
        }

        @Override
        public Stroke getInnerStroke() {
            return this.tmp;
        }

        public String toString() {
            return "Zigzag";
        }

        @Override
        public int getExtraWidth(int n) {
            return n / 2;
        }
    }
    ,
    OUTLINE{
        private static final float INNER_WIDTH = 0.5f;
        public BasicStroke innerStroke = new BasicStroke(0.5f);

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            CompositeStroke compositeStroke = new CompositeStroke(new BasicStroke(f, 1, 1), this.innerStroke);
            return compositeStroke;
        }

        @Override
        public Stroke getInnerStroke() {
            return this.innerStroke;
        }

        public String toString() {
            return "Outline";
        }

        @Override
        public int getExtraWidth(int n) {
            return 0;
        }
    }
    ,
    CALLIGRAPHY{

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            return new CalligraphyStroke(f);
        }

        public String toString() {
            return "Calligraphy";
        }

        @Override
        public int getExtraWidth(int n) {
            return 0;
        }
    }
    ,
    KIWI{

        @Override
        public Stroke getStroke(float f, int n, int n2, float[] fArray) {
            int n3 = (int)f;
            Kiwi kiwi = new Kiwi(0, 0, n3, n3);
            float f2 = f * 1.2f;
            if (fArray != null) {
                f2 *= 2.0f;
            }
            return new ShapeStroke(kiwi, f2);
        }

        public String toString() {
            return "Kiwi";
        }

        @Override
        public int getExtraWidth(int n) {
            return 0;
        }
    };


    public Stroke getInnerStroke() {
        return null;
    }

    public abstract Stroke getStroke(float var1, int var2, int var3, float[] var4);

    public abstract int getExtraWidth(int var1);

    public Stroke getStroke(float f) {
        return this.getStroke(f, 1, 1, null);
    }
}

