/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import pixelitor.tools.AbstractBrushTool;

public enum Symmetry {
    NO_SYMMETRY{

        public String toString() {
            return "None";
        }

        @Override
        public void drawPoint(AbstractBrushTool abstractBrushTool, int n, int n2) {
            abstractBrushTool.drawPoint(n, n2);
        }

        @Override
        public void drawLine(AbstractBrushTool abstractBrushTool, int n, int n2, int n3, int n4) {
            abstractBrushTool.drawLine(n, n2, n3, n4);
        }
    }
    ,
    VERTICAL_MIRROR{

        public String toString() {
            return "Vertical";
        }

        @Override
        public void drawPoint(AbstractBrushTool abstractBrushTool, int n, int n2) {
            abstractBrushTool.drawPoint(n, n2);
            abstractBrushTool.drawPoint(compositionWidth - n, n2);
        }

        @Override
        public void drawLine(AbstractBrushTool abstractBrushTool, int n, int n2, int n3, int n4) {
            abstractBrushTool.drawLine(n, n2, n3, n4);
            abstractBrushTool.drawLine(compositionWidth - n, n2, compositionWidth - n3, n4);
        }
    }
    ,
    HORIZONTAL_MIRROR{

        public String toString() {
            return "Horizontal";
        }

        @Override
        public void drawPoint(AbstractBrushTool abstractBrushTool, int n, int n2) {
            abstractBrushTool.drawPoint(n, n2);
            abstractBrushTool.drawPoint(n, compositionHeight - n2);
        }

        @Override
        public void drawLine(AbstractBrushTool abstractBrushTool, int n, int n2, int n3, int n4) {
            abstractBrushTool.drawLine(n, n2, n3, n4);
            abstractBrushTool.drawLine(n, compositionHeight - n2, n3, compositionHeight - n4);
        }
    }
    ,
    TWO_MIRRORS{

        public String toString() {
            return "Two Mirrors";
        }

        @Override
        public void drawPoint(AbstractBrushTool abstractBrushTool, int n, int n2) {
            abstractBrushTool.drawPoint(n, n2);
            abstractBrushTool.drawPoint(compositionWidth - n, n2);
            abstractBrushTool.drawPoint(n, compositionHeight - n2);
            abstractBrushTool.drawPoint(compositionWidth - n, compositionHeight - n2);
        }

        @Override
        public void drawLine(AbstractBrushTool abstractBrushTool, int n, int n2, int n3, int n4) {
            abstractBrushTool.drawLine(n, n2, n3, n4);
            abstractBrushTool.drawLine(n, compositionHeight - n2, n3, compositionHeight - n4);
            abstractBrushTool.drawLine(compositionWidth - n, n2, compositionWidth - n3, n4);
            abstractBrushTool.drawLine(compositionWidth - n, compositionHeight - n2, compositionWidth - n3, compositionHeight - n4);
        }
    }
    ,
    CENTRAL_SYMMETRY{

        public String toString() {
            return "Central Symmetry";
        }

        @Override
        public void drawPoint(AbstractBrushTool abstractBrushTool, int n, int n2) {
            abstractBrushTool.drawPoint(n, n2);
            abstractBrushTool.drawPoint(compositionWidth - n, compositionHeight - n2);
        }

        @Override
        public void drawLine(AbstractBrushTool abstractBrushTool, int n, int n2, int n3, int n4) {
            abstractBrushTool.drawLine(n, n2, n3, n4);
            abstractBrushTool.drawLine(compositionWidth - n, compositionHeight - n2, compositionWidth - n3, compositionHeight - n4);
        }
    };

    private static int compositionWidth;
    private static int compositionHeight;

    public static void setCompositionSize(int n, int n2) {
        compositionWidth = n;
        compositionHeight = n2;
    }

    public abstract void drawPoint(AbstractBrushTool var1, int var2, int var3);

    public abstract void drawLine(AbstractBrushTool var1, int var2, int var3, int var4, int var5);
}

