/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.ImageComponent;
import pixelitor.history.History;
import pixelitor.history.ImageEdit;
import pixelitor.history.PartialImageEdit;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.tools.ToolAffectedArea;
import pixelitor.tools.ToolButton;
import pixelitor.tools.ToolSettingsPanel;
import pixelitor.tools.UserDrag;
import pixelitor.tools.toolhandlers.ColorPickerToolEventHandler;
import pixelitor.tools.toolhandlers.HandToolEventHandler;
import pixelitor.tools.toolhandlers.ImageLayerCheckHandler;
import pixelitor.tools.toolhandlers.ToolEventHandler;
import pixelitor.tools.toolhandlers.ToolHandler;
import pixelitor.utils.Utils;

public abstract class Tool {
    private boolean mouseDown = false;
    private ToolButton toolButton;
    private final String name;
    private final String iconFileName;
    private final String toolMessage;
    protected Cursor cursor;
    private boolean constrainIfShiftDown;
    private boolean endPointInitialized = false;
    protected boolean spaceDragBehavior = false;
    UserDrag userDrag = new UserDrag();
    private final char activationKeyChar;
    ToolEventHandler handlerChainStart;
    private HandToolEventHandler handToolEventHandler;
    protected ToolSettingsPanel toolSettingsPanel;

    protected Tool(char c, String string, String string2, String string3, Cursor cursor, boolean bl, boolean bl2, boolean bl3) {
        this.activationKeyChar = c;
        this.name = string;
        this.iconFileName = string2;
        this.toolMessage = string3;
        this.cursor = cursor;
        this.constrainIfShiftDown = bl3;
        this.initHandlerChain(cursor, bl, bl2);
    }

    private void initHandlerChain(Cursor cursor, boolean bl, boolean bl2) {
        ToolEventHandler toolEventHandler = null;
        if (bl) {
            toolEventHandler = this.addHandlerToChain(new ImageLayerCheckHandler(), toolEventHandler);
        }
        if (bl2) {
            this.handToolEventHandler = new HandToolEventHandler(cursor);
            toolEventHandler = this.addHandlerToChain(this.handToolEventHandler, toolEventHandler);
        }
        if (this instanceof AbstractBrushTool) {
            ColorPickerToolEventHandler colorPickerToolEventHandler = new ColorPickerToolEventHandler();
            toolEventHandler = this.addHandlerToChain(colorPickerToolEventHandler, toolEventHandler);
        }
        toolEventHandler = this.addHandlerToChain(new ToolHandler(this), toolEventHandler);
    }

    private ToolEventHandler addHandlerToChain(ToolEventHandler toolEventHandler, ToolEventHandler toolEventHandler2) {
        if (toolEventHandler2 == null) {
            this.handlerChainStart = toolEventHandler;
            return this.handlerChainStart;
        }
        toolEventHandler2.setSuccessor(toolEventHandler);
        return toolEventHandler;
    }

    public String getToolMessage() {
        return this.toolMessage;
    }

    public boolean mouseClicked(MouseEvent mouseEvent, ImageComponent imageComponent) {
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.mouseDown) {
            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this.userDrag.getEndX(), this.userDrag.getEndY(), 1, false);
            this.mouseReleased(mouseEvent2, imageComponent);
        }
        this.mouseDown = true;
        this.userDrag.setStartFromMouseEvent(mouseEvent, imageComponent);
        this.handlerChainStart.handleMousePressed(mouseEvent, imageComponent);
        this.endPointInitialized = false;
    }

    public void mouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (!this.mouseDown) {
            this.mousePressed(mouseEvent, imageComponent);
        }
        this.mouseDown = false;
        this.userDrag.setEndFromMouseEvent(mouseEvent, imageComponent);
        this.handlerChainStart.handleMouseReleased(mouseEvent, imageComponent);
        this.endPointInitialized = false;
    }

    public void mouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (!this.mouseDown) {
            this.mousePressed(mouseEvent, imageComponent);
        }
        this.mouseDown = true;
        if (this.spaceDragBehavior) {
            this.userDrag.saveEndValues();
        }
        if (this.constrainIfShiftDown) {
            this.userDrag.setConstrainPoints(mouseEvent.isShiftDown());
        }
        this.userDrag.setEndFromMouseEvent(mouseEvent, imageComponent);
        if (this.spaceDragBehavior) {
            if (this.endPointInitialized && GlobalKeyboardWatch.isSpaceDown()) {
                this.userDrag.adjustStartForSpaceDownMove();
            }
            this.endPointInitialized = true;
        }
        this.handlerChainStart.handleMouseDragged(mouseEvent, imageComponent);
    }

    void setButton(ToolButton toolButton) {
        this.toolButton = toolButton;
    }

    public ToolButton getButton() {
        return this.toolButton;
    }

    abstract void initSettingsPanel();

    public String getName() {
        return this.name;
    }

    protected String getIconFileName() {
        return this.iconFileName;
    }

    public char getActivationKeyChar() {
        return this.activationKeyChar;
    }

    void saveImageForUndo(Composition composition) {
        BufferedImage bufferedImage = composition.getImageOrSubImageIfSelectedForActiveLayer(true, true);
        ImageEdit imageEdit = new ImageEdit(this.getName(), composition, bufferedImage, false);
        History.addEdit(imageEdit);
    }

    public void saveSubImageForUndo(BufferedImage bufferedImage, ToolAffectedArea toolAffectedArea) {
        assert (bufferedImage != null);
        Rectangle rectangle = toolAffectedArea.getRectangle();
        if (rectangle.isEmpty()) {
            return;
        }
        Composition composition = toolAffectedArea.getComp();
        Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (!rectangle3.isEmpty()) {
            PartialImageEdit partialImageEdit = new PartialImageEdit(this.getName(), composition, bufferedImage, rectangle3, false);
            History.addEdit(partialImageEdit);
        }
    }

    public void spacePressed() {
        if (this.handToolEventHandler != null) {
            this.handToolEventHandler.spacePressed();
        }
    }

    public void spaceReleased() {
        if (this.handToolEventHandler != null) {
            this.handToolEventHandler.spaceReleased();
        }
    }

    protected void toolStarted() {
        AppLogic.setToolCursor(this.cursor);
    }

    protected void toolEnded() {
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paintOverLayer(Graphics2D graphics2D) {
    }

    public void paintOverImage(Graphics2D graphics2D) {
    }

    public void mouseMoved(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    public abstract void toolMousePressed(MouseEvent var1, ImageComponent var2);

    public abstract void toolMouseDragged(MouseEvent var1, ImageComponent var2);

    public abstract void toolMouseReleased(MouseEvent var1, ImageComponent var2);

    public void setToolSettingsPanel(ToolSettingsPanel toolSettingsPanel) {
        this.toolSettingsPanel = toolSettingsPanel;
    }

    public void randomize() {
        Utils.randomizeGUIWidgetsOn(this.toolSettingsPanel);
    }
}

